/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page;

import com.helger.annotation.Nonempty;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.base.name.IHasDisplayName;
import com.helger.base.state.EContinue;
import com.helger.base.string.StringHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.IHCForm;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.security.lock.DefaultLockManager;
import com.helger.photon.security.lock.LockResult;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.user.IUser;
import com.helger.photon.uicore.html.toolbar.IButtonToolbar;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.AbstractWebPage;
import com.helger.photon.uicore.page.EShowObject;
import com.helger.photon.uicore.page.EWebPageSimpleFormAction;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.IWebPageFormUIHandler;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayText;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractWebPageSimpleForm<DATATYPE extends IHasID<String>, WPECTYPE extends IWebPageExecutionContext, FORM_TYPE extends IHCForm<FORM_TYPE>, TOOLBAR_TYPE extends IButtonToolbar<TOOLBAR_TYPE>>
extends AbstractWebPage<WPECTYPE> {
    public static final String FORM_ID_INPUT = "inputform";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWebPageSimpleForm.class);
    private final IWebPageFormUIHandler<FORM_TYPE, TOOLBAR_TYPE> m_aUIHandler;

    public AbstractWebPageSimpleForm(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2, @Nonnull IWebPageFormUIHandler<FORM_TYPE, TOOLBAR_TYPE> iWebPageFormUIHandler) {
        super(string, iMultilingualText, iMultilingualText2);
        this.m_aUIHandler = (IWebPageFormUIHandler)ValueEnforcer.notNull(iWebPageFormUIHandler, (String)"UIHandler");
    }

    @Nonnull
    protected final IWebPageFormUIHandler<FORM_TYPE, TOOLBAR_TYPE> getUIHandler() {
        return this.m_aUIHandler;
    }

    @Nullable
    @OverrideOnDemand
    protected String getObjectDisplayName(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE) {
        return null;
    }

    @OverrideOnDemand
    protected boolean isFileUploadForm(@Nonnull WPECTYPE WPECTYPE) {
        return false;
    }

    @Nonnull
    public static SimpleURL createViewURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull String string, @Nonnull IHasID<String> iHasID) {
        return AbstractWebPageSimpleForm.createViewURL(iLayoutExecutionContext, string, (String)iHasID.getID());
    }

    @Nonnull
    public static SimpleURL createViewURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull String string, @Nonnull String string2) {
        return iLayoutExecutionContext.getLinkToMenuItem(string).add("action", "view").add("object", string2);
    }

    @Nonnull
    public static SimpleURL createViewURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID) {
        return AbstractWebPageSimpleForm.createViewURL(iLayoutExecutionContext, (String)iHasID.getID());
    }

    @Nonnull
    public static SimpleURL createViewURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull String string) {
        return iLayoutExecutionContext.getSelfHref().add("action", "view").add("object", string);
    }

    @Nonnull
    public static <T extends IHasDisplayName & IHasID<String>> HCA createEditLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t) {
        return AbstractWebPageSimpleForm.createEditLink(iLayoutExecutionContext, t, (Map<String, String>)null);
    }

    @Nonnull
    public static <T extends IHasDisplayName & IHasID<String>> HCA createEditLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t, @Nullable Map<String, String> map) {
        Locale locale = iLayoutExecutionContext.getDisplayLocale();
        return AbstractWebPageSimpleForm.createEditLink(iLayoutExecutionContext, t, EWebPageText.OBJECT_EDIT.getDisplayTextWithArgs(locale, new Object[]{t.getDisplayName()}), map);
    }

    @Nonnull
    public static <T extends IHasDisplayText & IHasID<String>> HCA createEditLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t) {
        return AbstractWebPageSimpleForm.createEditLink(iLayoutExecutionContext, t, (Map<String, String>)null);
    }

    @Nonnull
    public static <T extends IHasDisplayText & IHasID<String>> HCA createEditLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t, @Nullable Map<String, String> map) {
        Locale locale = iLayoutExecutionContext.getDisplayLocale();
        return AbstractWebPageSimpleForm.createEditLink(iLayoutExecutionContext, t, EWebPageText.OBJECT_EDIT.getDisplayTextWithArgs(locale, new Object[]{t.getDisplayText(locale)}), map);
    }

    @Nonnull
    public static SimpleURL createEditURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID) {
        return iLayoutExecutionContext.getSelfHref().add("action", "edit").add("object", (String)iHasID.getID());
    }

    @Nonnull
    public static HCA createEditLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable String string) {
        return AbstractWebPageSimpleForm.createEditLink(iLayoutExecutionContext, iHasID, string, null);
    }

    @Nonnull
    public static HCA createEditLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable String string, @Nullable Map<String, String> map) {
        SimpleURL simpleURL = AbstractWebPageSimpleForm.createEditURL(iLayoutExecutionContext, iHasID).addAll(map);
        return (HCA)((HCA)new HCA((ISimpleURL)simpleURL).setTitle(string)).addChild(EDefaultIcon.EDIT.getAsNode());
    }

    @Nonnull
    @OverrideOnDemand
    protected TOOLBAR_TYPE createNewViewToolbar(@Nonnull WPECTYPE WPECTYPE) {
        return this.getUIHandler().createToolbar((ILayoutExecutionContext)WPECTYPE);
    }

    @OverrideOnDemand
    protected boolean showViewToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE) {
        return true;
    }

    @OverrideOnDemand
    protected void modifyViewToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE, @Nonnull TOOLBAR_TYPE TOOLBAR_TYPE) {
    }

    @Nonnull
    @OverrideOnDemand
    protected TOOLBAR_TYPE createViewToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        TOOLBAR_TYPE TOOLBAR_TYPE = this.createNewViewToolbar(WPECTYPE);
        if (this.isActionAllowed(WPECTYPE, EWebPageSimpleFormAction.EDIT, DATATYPE)) {
            TOOLBAR_TYPE.addButtonEdit(locale, (ISimpleURL)AbstractWebPageSimpleForm.createEditURL(WPECTYPE, DATATYPE));
        }
        this.modifyViewToolbar(WPECTYPE, DATATYPE, TOOLBAR_TYPE);
        return TOOLBAR_TYPE;
    }

    @Nonnull
    @OverrideOnDemand
    protected TOOLBAR_TYPE createNewEditToolbar(@Nonnull WPECTYPE WPECTYPE) {
        return this.getUIHandler().createToolbar((ILayoutExecutionContext)WPECTYPE);
    }

    @OverrideOnDemand
    protected boolean showEditToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE) {
        return true;
    }

    @OverrideOnDemand
    protected void modifyEditToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE, @Nonnull TOOLBAR_TYPE TOOLBAR_TYPE) {
    }

    @Nullable
    @OverrideOnDemand
    protected String getEditToolbarSubmitButtonText(@Nonnull Locale locale) {
        return EPhotonCoreText.BUTTON_SAVE.getDisplayText(locale);
    }

    @Nullable
    @OverrideOnDemand
    protected IIcon getEditToolbarSubmitButtonIcon() {
        return EDefaultIcon.SAVE;
    }

    @Nonnull
    @OverrideOnDemand
    protected TOOLBAR_TYPE createEditToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull FORM_TYPE FORM_TYPE, @Nonnull DATATYPE DATATYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        TOOLBAR_TYPE TOOLBAR_TYPE = this.createNewEditToolbar(WPECTYPE);
        TOOLBAR_TYPE.addHiddenField("action", "edit");
        TOOLBAR_TYPE.addHiddenField("action2", "save");
        TOOLBAR_TYPE.addHiddenField("object", (String)DATATYPE.getID());
        TOOLBAR_TYPE.addSubmitButton(this.getEditToolbarSubmitButtonText(locale), this.getEditToolbarSubmitButtonIcon());
        TOOLBAR_TYPE.addButtonCancel(locale);
        this.modifyEditToolbar(WPECTYPE, DATATYPE, TOOLBAR_TYPE);
        return TOOLBAR_TYPE;
    }

    @OverrideOnDemand
    protected boolean isActionAllowed(@Nonnull WPECTYPE WPECTYPE, @Nonnull EWebPageSimpleFormAction eWebPageSimpleFormAction, @Nonnull DATATYPE DATATYPE) {
        return true;
    }

    @Nonnull
    protected abstract DATATYPE getObject(@Nonnull WPECTYPE var1);

    @OverrideOnDemand
    protected boolean isObjectLockingEnabled() {
        return true;
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected EContinue beforeProcessing(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE, @Nonnull EWebPageSimpleFormAction eWebPageSimpleFormAction) {
        if (this.isObjectLockingEnabled()) {
            DefaultLockManager defaultLockManager = PhotonSecurityManager.getLockMgr();
            if (eWebPageSimpleFormAction.isModifying() && DATATYPE != null) {
                String string = (String)DATATYPE.getID();
                LockResult lockResult = defaultLockManager.lockObjectAndUnlockAllOthers((Object)string);
                if (lockResult.isNotLocked()) {
                    Locale locale = WPECTYPE.getDisplayLocale();
                    HCNodeList hCNodeList = WPECTYPE.getNodeList();
                    String string2 = defaultLockManager.getLockUserID((Object)string);
                    IUser iUser = PhotonSecurityManager.getUserMgr().getUserOfID(string2);
                    String string3 = this.getObjectDisplayName(WPECTYPE, DATATYPE);
                    Object object = StringHelper.isNotEmpty((String)string3) ? " '" + string3 + "'" : "";
                    Object object2 = iUser != null ? "'" + iUser.getDisplayName() + "'" : EWebPageText.LOCKING_OTHER_USER.getDisplayText(locale);
                    hCNodeList.addChild(this.getUIHandler().createErrorBox((ILayoutExecutionContext)WPECTYPE, EWebPageText.LOCKING_FAILED.getDisplayTextWithArgs(locale, new Object[]{object, object2})));
                    return EContinue.BREAK;
                }
            } else {
                defaultLockManager.unlockAllObjectsOfCurrentUser();
            }
        }
        return EContinue.CONTINUE;
    }

    @OverrideOnDemand
    protected void afterProcessing(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE, @Nonnull EWebPageSimpleFormAction eWebPageSimpleFormAction) {
    }

    protected abstract void showObject(@Nonnull WPECTYPE var1, @Nonnull DATATYPE var2);

    protected final void handleViewObject(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE) {
        this.showObject(WPECTYPE, DATATYPE);
        if (this.showViewToolbar(WPECTYPE, DATATYPE)) {
            WPECTYPE.getNodeList().addChild(this.createViewToolbar(WPECTYPE, DATATYPE));
        }
    }

    protected abstract void validateAndSaveInputParameters(@Nonnull WPECTYPE var1, @Nonnull DATATYPE var2, @Nonnull FormErrorList var3, @Nonnull EWebPageSimpleFormAction var4);

    @OverrideOnDemand
    protected void onInputFormFinishedSuccess(@Nonnull WPECTYPE WPECTYPE) {
    }

    @OverrideOnDemand
    protected void onInputFormError(@Nonnull WPECTYPE WPECTYPE, @Nonnull FormErrorList formErrorList) {
    }

    @OverrideOnDemand
    protected void modifyFormBeforeShowInputForm(@Nonnull WPECTYPE WPECTYPE, @Nonnull FORM_TYPE FORM_TYPE) {
    }

    protected abstract void showInputForm(@Nonnull WPECTYPE var1, @Nonnull DATATYPE var2, @Nonnull FORM_TYPE var3, @Nonnull EWebPageSimpleFormAction var4, @Nonnull FormErrorList var5);

    @OverrideOnDemand
    protected void modifyFormAfterShowInputForm(@Nonnull WPECTYPE WPECTYPE, @Nonnull FORM_TYPE FORM_TYPE) {
    }

    @OverrideOnDemand
    protected EShowObject handleCustomActions(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE) {
        return EShowObject.SHOW_OBJECT;
    }

    @Override
    protected final void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        DATATYPE DATATYPE = this.getObject(WPECTYPE);
        if (DATATYPE == null) {
            throw new IllegalStateException("No object present!");
        }
        EShowObject eShowObject = EShowObject.SHOW_OBJECT;
        String string = WPECTYPE.getAction();
        EWebPageSimpleFormAction eWebPageSimpleFormAction = "edit".equals(string) ? EWebPageSimpleFormAction.EDIT : ("view".equals(string) || StringHelper.isEmpty((String)string) ? EWebPageSimpleFormAction.VIEW : EWebPageSimpleFormAction.CUSTOM);
        if (!this.isActionAllowed(WPECTYPE, eWebPageSimpleFormAction, DATATYPE)) {
            LOGGER.info("Action " + String.valueOf((Object)eWebPageSimpleFormAction) + " is not allowed on object " + (String)DATATYPE.getID());
            eWebPageSimpleFormAction = EWebPageSimpleFormAction.DEFAULT;
        }
        if (this.beforeProcessing(WPECTYPE, DATATYPE, eWebPageSimpleFormAction).isContinue()) {
            switch (eWebPageSimpleFormAction) {
                case EDIT: {
                    FormErrorList formErrorList = new FormErrorList();
                    boolean bl = true;
                    boolean bl2 = WPECTYPE.hasSubAction("save");
                    if (bl2 && this.getCSRFHandler().checkCSRFNonce((IWebPageExecutionContext)WPECTYPE).isContinue()) {
                        this.validateAndSaveInputParameters(WPECTYPE, DATATYPE, formErrorList, eWebPageSimpleFormAction);
                        if (formErrorList.isEmpty()) {
                            bl = false;
                            this.onInputFormFinishedSuccess(WPECTYPE);
                        } else {
                            hCNodeList.addChild(this.getUIHandler().createIncorrectInputBox((ILayoutExecutionContext)WPECTYPE));
                            this.onInputFormError(WPECTYPE, formErrorList);
                        }
                    }
                    if (!bl) break;
                    eShowObject = EShowObject.DONT_SHOW_OBJECT;
                    FORM_TYPE FORM_TYPE = this.isFileUploadForm(WPECTYPE) ? this.getUIHandler().createFormFileUploadSelf((ILayoutExecutionContext)WPECTYPE) : this.getUIHandler().createFormSelf((ILayoutExecutionContext)WPECTYPE);
                    hCNodeList.addChild(FORM_TYPE);
                    FORM_TYPE.setID(FORM_ID_INPUT);
                    FORM_TYPE.addChild((IHCNode)this.getCSRFHandler().createCSRFNonceField());
                    this.modifyFormBeforeShowInputForm(WPECTYPE, FORM_TYPE);
                    this.showInputForm(WPECTYPE, DATATYPE, FORM_TYPE, eWebPageSimpleFormAction, formErrorList);
                    this.modifyFormAfterShowInputForm(WPECTYPE, FORM_TYPE);
                    if (!this.showEditToolbar(WPECTYPE, DATATYPE)) break;
                    FORM_TYPE.addChild(this.createEditToolbar(WPECTYPE, FORM_TYPE, DATATYPE));
                    break;
                }
                case CUSTOM: {
                    eShowObject = this.handleCustomActions(WPECTYPE, DATATYPE);
                }
            }
        }
        if (eShowObject == EShowObject.SHOW_OBJECT) {
            this.handleViewObject(WPECTYPE, DATATYPE);
        }
        this.afterProcessing(WPECTYPE, DATATYPE, eWebPageSimpleFormAction);
    }
}

