/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.base.name.IHasDisplayName;
import com.helger.base.state.EContinue;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.css.ECSSUnit;
import com.helger.css.property.CCSSProperties;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.IHCForm;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.html.textlevel.HCSpan;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.security.lock.DefaultLockManager;
import com.helger.photon.security.lock.LockResult;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.user.IUser;
import com.helger.photon.uicore.css.CUICoreCSS;
import com.helger.photon.uicore.html.toolbar.IButtonToolbar;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.AbstractWebPage;
import com.helger.photon.uicore.page.EShowList;
import com.helger.photon.uicore.page.EWebPageFormAction;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.IWebPageFormUIHandler;
import com.helger.photon.uicore.page.handler.IWebPageActionHandler;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayText;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractWebPageForm<DATATYPE extends IHasID<String>, WPECTYPE extends IWebPageExecutionContext, FORM_TYPE extends IHCForm<FORM_TYPE>, TOOLBAR_TYPE extends IButtonToolbar<TOOLBAR_TYPE>>
extends AbstractWebPage<WPECTYPE> {
    public static final String FORM_ID_INPUT = "inputform";
    public static final boolean DEFAULT_OBJECT_LOCKING_ENABLED = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWebPageForm.class);
    private final IWebPageFormUIHandler<FORM_TYPE, TOOLBAR_TYPE> m_aUIHandler;
    private IWebPageActionHandler<DATATYPE, WPECTYPE> m_aDeleteHandler;
    private IWebPageActionHandler<DATATYPE, WPECTYPE> m_aUndeleteHandler;
    private final ICommonsMap<String, IWebPageActionHandler<DATATYPE, WPECTYPE>> m_aCustomHandlers = new CommonsHashMap();
    private boolean m_bObjectLockingEnabled = false;

    public AbstractWebPageForm(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2, @Nonnull IWebPageFormUIHandler<FORM_TYPE, TOOLBAR_TYPE> iWebPageFormUIHandler) {
        super(string, iMultilingualText, iMultilingualText2);
        this.m_aUIHandler = (IWebPageFormUIHandler)ValueEnforcer.notNull(iWebPageFormUIHandler, (String)"UIHandler");
    }

    @Nonnull
    protected final IWebPageFormUIHandler<FORM_TYPE, TOOLBAR_TYPE> getUIHandler() {
        return this.m_aUIHandler;
    }

    protected final void setDeleteHandler(@Nullable IWebPageActionHandler<DATATYPE, WPECTYPE> iWebPageActionHandler) {
        this.m_aDeleteHandler = iWebPageActionHandler;
    }

    protected final void setUndeleteHandler(@Nullable IWebPageActionHandler<DATATYPE, WPECTYPE> iWebPageActionHandler) {
        this.m_aUndeleteHandler = iWebPageActionHandler;
    }

    protected final void addCustomHandler(@Nonnull @Nonempty String string, @Nullable IWebPageActionHandler<DATATYPE, WPECTYPE> iWebPageActionHandler) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ActionName");
        if (iWebPageActionHandler != null) {
            if (this.m_aCustomHandlers.containsKey((Object)string)) {
                throw new IllegalArgumentException("A custom handler for action '" + string + "' is already registered!");
            }
            this.m_aCustomHandlers.put((Object)string, iWebPageActionHandler);
        }
    }

    protected final void setObjectLockingEnabled(boolean bl) {
        this.m_bObjectLockingEnabled = bl;
    }

    protected final boolean isObjectLockingEnabled() {
        return this.m_bObjectLockingEnabled;
    }

    @Nullable
    @OverrideOnDemand
    protected String getObjectDisplayName(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE) {
        return null;
    }

    @OverrideOnDemand
    protected boolean isFileUploadForm(@Nonnull WPECTYPE WPECTYPE) {
        return false;
    }

    @Nullable
    protected final String getSelectedObjectID(@Nonnull WPECTYPE WPECTYPE) {
        return WPECTYPE.params().getAsString((Object)"object");
    }

    @Nonnull
    public static HCSpan createEmptyAction() {
        return AbstractWebPageForm.createEmptyAction(16);
    }

    @Nonnull
    public static HCSpan createEmptyAction(@Nonnegative int n) {
        return (HCSpan)((HCSpan)((HCSpan)new HCSpan().addClass(CUICoreCSS.CSS_CLASS_EMPTY_ACTION)).addStyle(CCSSProperties.DISPLAY_INLINE_BLOCK)).addStyle(CCSSProperties.WIDTH.newValue(ECSSUnit.px((int)n)));
    }

    @Nonnull
    public static SimpleURL createCreateURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull String string) {
        return iLayoutExecutionContext.getLinkToMenuItem(string).add("action", "create");
    }

    @Nonnull
    public static SimpleURL createCreateURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext) {
        return iLayoutExecutionContext.getSelfHref().add("action", "create");
    }

    @Nonnull
    public static SimpleURL createViewURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull String string, @Nonnull IHasID<String> iHasID) {
        return AbstractWebPageForm.createViewURL(iLayoutExecutionContext, string, iHasID, (Map<String, String>)null);
    }

    @Nonnull
    public static SimpleURL createViewURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull String string, @Nonnull IHasID<String> iHasID, @Nullable Map<String, String> map) {
        return AbstractWebPageForm.createViewURL(iLayoutExecutionContext, string, (String)iHasID.getID(), map);
    }

    @Nonnull
    public static SimpleURL createViewURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull String string, @Nonnull String string2) {
        return AbstractWebPageForm.createViewURL(iLayoutExecutionContext, string, string2, (Map<String, String>)null);
    }

    @Nonnull
    public static SimpleURL createViewURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull String string, @Nonnull String string2, @Nullable Map<String, String> map) {
        return iLayoutExecutionContext.getLinkToMenuItem(string).add("action", "view").add("object", string2).addAll(map);
    }

    @Nonnull
    public static SimpleURL createViewURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID) {
        return AbstractWebPageForm.createViewURL(iLayoutExecutionContext, iHasID, (Map<String, String>)null);
    }

    @Nonnull
    public static SimpleURL createViewURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable Map<String, String> map) {
        return AbstractWebPageForm.createViewURL(iLayoutExecutionContext, (String)iHasID.getID(), map);
    }

    @Nonnull
    public static SimpleURL createViewURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull String string) {
        return AbstractWebPageForm.createViewURL(iLayoutExecutionContext, string, (Map<String, String>)null);
    }

    @Nonnull
    public static SimpleURL createViewURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull String string, @Nullable Map<String, String> map) {
        return iLayoutExecutionContext.getSelfHref().add("action", "view").add("object", string).addAll(map);
    }

    @Nonnull
    public static <T extends IHasDisplayName & IHasID<String>> HCA createEditLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t) {
        return AbstractWebPageForm.createEditLink(iLayoutExecutionContext, t, (Map<String, String>)null);
    }

    @Nonnull
    public static <T extends IHasDisplayName & IHasID<String>> HCA createEditLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t, @Nullable Map<String, String> map) {
        Locale locale = iLayoutExecutionContext.getDisplayLocale();
        return AbstractWebPageForm.createEditLink(iLayoutExecutionContext, t, EWebPageText.OBJECT_EDIT.getDisplayTextWithArgs(locale, new Object[]{t.getDisplayName()}), map);
    }

    @Nonnull
    public static <T extends IHasDisplayText & IHasID<String>> HCA createEditLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t) {
        return AbstractWebPageForm.createEditLink(iLayoutExecutionContext, t, (Map<String, String>)null);
    }

    @Nonnull
    public static <T extends IHasDisplayText & IHasID<String>> HCA createEditLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t, @Nullable Map<String, String> map) {
        Locale locale = iLayoutExecutionContext.getDisplayLocale();
        return AbstractWebPageForm.createEditLink(iLayoutExecutionContext, t, EWebPageText.OBJECT_EDIT.getDisplayTextWithArgs(locale, new Object[]{t.getDisplayText(locale)}), map);
    }

    @Nonnull
    public static SimpleURL createEditURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID) {
        return iLayoutExecutionContext.getSelfHref().add("action", "edit").add("object", (String)iHasID.getID());
    }

    @Nonnull
    public static HCA createEditLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable String string) {
        return AbstractWebPageForm.createEditLink(iLayoutExecutionContext, iHasID, string, null);
    }

    @Nonnull
    public static HCA createEditLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable String string, @Nullable Map<String, String> map) {
        SimpleURL simpleURL = AbstractWebPageForm.createEditURL(iLayoutExecutionContext, iHasID).addAll(map);
        return (HCA)((HCA)new HCA((ISimpleURL)simpleURL).setTitle(string)).addChild(EDefaultIcon.EDIT.getAsNode());
    }

    @Nonnull
    public static <T extends IHasDisplayName & IHasID<String>> HCA createCopyLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t) {
        return AbstractWebPageForm.createCopyLink(iLayoutExecutionContext, t, (Map<String, String>)null);
    }

    @Nonnull
    public static <T extends IHasDisplayName & IHasID<String>> HCA createCopyLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t, @Nullable Map<String, String> map) {
        Locale locale = iLayoutExecutionContext.getDisplayLocale();
        return AbstractWebPageForm.createCopyLink(iLayoutExecutionContext, t, EWebPageText.OBJECT_COPY.getDisplayTextWithArgs(locale, new Object[]{t.getDisplayName()}), map);
    }

    @Nonnull
    public static <T extends IHasDisplayText & IHasID<String>> HCA createCopyLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t) {
        return AbstractWebPageForm.createCopyLink(iLayoutExecutionContext, t, (Map<String, String>)null);
    }

    @Nonnull
    public static <T extends IHasDisplayText & IHasID<String>> HCA createCopyLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t, @Nullable Map<String, String> map) {
        Locale locale = iLayoutExecutionContext.getDisplayLocale();
        return AbstractWebPageForm.createCopyLink(iLayoutExecutionContext, t, EWebPageText.OBJECT_COPY.getDisplayTextWithArgs(locale, new Object[]{t.getDisplayText(locale)}), map);
    }

    @Nonnull
    public static SimpleURL createCopyURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID) {
        return AbstractWebPageForm.createCopyURL(iLayoutExecutionContext, iHasID, null);
    }

    @Nonnull
    public static SimpleURL createCopyURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable Map<String, String> map) {
        return iLayoutExecutionContext.getSelfHref().add("action", "copy").add("object", (String)iHasID.getID()).addAll(map);
    }

    @Nonnull
    public static HCA createCopyLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable String string) {
        return AbstractWebPageForm.createCopyLink(iLayoutExecutionContext, iHasID, string, null);
    }

    @Nonnull
    public static HCA createCopyLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable String string, @Nullable Map<String, String> map) {
        SimpleURL simpleURL = AbstractWebPageForm.createCopyURL(iLayoutExecutionContext, iHasID, map);
        return (HCA)((HCA)new HCA((ISimpleURL)simpleURL).setTitle(string)).addChild(EDefaultIcon.COPY.getAsNode());
    }

    @Nonnull
    public static <T extends IHasDisplayName & IHasID<String>> HCA createDeleteLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t) {
        return AbstractWebPageForm.createDeleteLink(iLayoutExecutionContext, t, (Map<String, String>)null);
    }

    @Nonnull
    public static <T extends IHasDisplayName & IHasID<String>> HCA createDeleteLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t, @Nullable Map<String, String> map) {
        Locale locale = iLayoutExecutionContext.getDisplayLocale();
        return AbstractWebPageForm.createDeleteLink(iLayoutExecutionContext, t, EWebPageText.OBJECT_DELETE.getDisplayTextWithArgs(locale, new Object[]{t.getDisplayName()}), map);
    }

    @Nonnull
    public static <T extends IHasDisplayText & IHasID<String>> HCA createDeleteLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t) {
        return AbstractWebPageForm.createDeleteLink(iLayoutExecutionContext, t, (Map<String, String>)null);
    }

    @Nonnull
    public static <T extends IHasDisplayText & IHasID<String>> HCA createDeleteLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t, @Nullable Map<String, String> map) {
        Locale locale = iLayoutExecutionContext.getDisplayLocale();
        return AbstractWebPageForm.createDeleteLink(iLayoutExecutionContext, t, EWebPageText.OBJECT_DELETE.getDisplayTextWithArgs(locale, new Object[]{t.getDisplayText(locale)}), map);
    }

    @Nonnull
    public static SimpleURL createDeleteURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID) {
        return AbstractWebPageForm.createDeleteURL(iLayoutExecutionContext, iHasID, null);
    }

    @Nonnull
    public static SimpleURL createDeleteURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable Map<String, String> map) {
        return iLayoutExecutionContext.getSelfHref().add("action", "delete").add("object", (String)iHasID.getID()).addAll(map);
    }

    @Nonnull
    public static HCA createDeleteLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable String string) {
        return AbstractWebPageForm.createDeleteLink(iLayoutExecutionContext, iHasID, string, null);
    }

    @Nonnull
    public static HCA createDeleteLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable String string, @Nullable Map<String, String> map) {
        SimpleURL simpleURL = AbstractWebPageForm.createDeleteURL(iLayoutExecutionContext, iHasID, map);
        return (HCA)((HCA)new HCA((ISimpleURL)simpleURL).setTitle(string)).addChild(EDefaultIcon.DELETE.getAsNode());
    }

    @Nonnull
    public static <T extends IHasDisplayName & IHasID<String>> HCA createUndeleteLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t) {
        return AbstractWebPageForm.createUndeleteLink(iLayoutExecutionContext, t, (Map<String, String>)null);
    }

    @Nonnull
    public static <T extends IHasDisplayName & IHasID<String>> HCA createUndeleteLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t, @Nullable Map<String, String> map) {
        Locale locale = iLayoutExecutionContext.getDisplayLocale();
        return AbstractWebPageForm.createUndeleteLink(iLayoutExecutionContext, t, EWebPageText.OBJECT_UNDELETE.getDisplayTextWithArgs(locale, new Object[]{t.getDisplayName()}), map);
    }

    @Nonnull
    public static <T extends IHasDisplayText & IHasID<String>> HCA createUndeleteLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t) {
        return AbstractWebPageForm.createUndeleteLink(iLayoutExecutionContext, t, (Map<String, String>)null);
    }

    @Nonnull
    public static <T extends IHasDisplayText & IHasID<String>> HCA createUndeleteLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull T t, @Nullable Map<String, String> map) {
        Locale locale = iLayoutExecutionContext.getDisplayLocale();
        return AbstractWebPageForm.createUndeleteLink(iLayoutExecutionContext, t, EWebPageText.OBJECT_UNDELETE.getDisplayTextWithArgs(locale, new Object[]{t.getDisplayText(locale)}), map);
    }

    @Nonnull
    public static SimpleURL createUndeleteURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID) {
        return AbstractWebPageForm.createUndeleteURL(iLayoutExecutionContext, iHasID, null);
    }

    @Nonnull
    public static SimpleURL createUndeleteURL(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable Map<String, String> map) {
        return iLayoutExecutionContext.getSelfHref().add("action", "undelete").add("object", (String)iHasID.getID()).addAll(map);
    }

    @Nonnull
    public static HCA createUndeleteLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable String string) {
        return AbstractWebPageForm.createUndeleteLink(iLayoutExecutionContext, iHasID, string, null);
    }

    @Nonnull
    public static HCA createUndeleteLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable String string, @Nullable Map<String, String> map) {
        SimpleURL simpleURL = AbstractWebPageForm.createUndeleteURL(iLayoutExecutionContext, iHasID, map);
        return (HCA)((HCA)new HCA((ISimpleURL)simpleURL).setTitle(string)).addChild(EDefaultIcon.UNDELETE.getAsNode());
    }

    @Nonnull
    public static HCA createNestedCreateLink(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHasID<String> iHasID, @Nullable String string) {
        SimpleURL simpleURL = AbstractWebPageForm.createCreateURL(iLayoutExecutionContext).add("object", (String)iHasID.getID());
        return (HCA)((HCA)new HCA((ISimpleURL)simpleURL).setTitle(string)).addChild(EDefaultIcon.NEW.getAsNode());
    }

    @Nonnull
    @OverrideOnDemand
    protected TOOLBAR_TYPE createNewViewToolbar(@Nonnull WPECTYPE WPECTYPE) {
        return this.getUIHandler().createToolbar((ILayoutExecutionContext)WPECTYPE);
    }

    @OverrideOnDemand
    protected boolean showViewToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE) {
        return true;
    }

    @OverrideOnDemand
    protected void modifyViewToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE, @Nonnull TOOLBAR_TYPE TOOLBAR_TYPE) {
    }

    @Nonnull
    @OverrideOnDemand
    protected TOOLBAR_TYPE createViewToolbar(@Nonnull WPECTYPE WPECTYPE, boolean bl, @Nonnull DATATYPE DATATYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        TOOLBAR_TYPE TOOLBAR_TYPE = this.createNewViewToolbar(WPECTYPE);
        if (bl) {
            TOOLBAR_TYPE.addButtonBack(locale);
        }
        if (this.isActionAllowed(WPECTYPE, EWebPageFormAction.EDIT, DATATYPE)) {
            TOOLBAR_TYPE.addButtonEdit(locale, (ISimpleURL)AbstractWebPageForm.createEditURL(WPECTYPE, DATATYPE));
        }
        this.modifyViewToolbar(WPECTYPE, DATATYPE, TOOLBAR_TYPE);
        return TOOLBAR_TYPE;
    }

    @Nonnull
    @OverrideOnDemand
    protected TOOLBAR_TYPE createNewEditToolbar(@Nonnull WPECTYPE WPECTYPE) {
        return this.getUIHandler().createToolbar((ILayoutExecutionContext)WPECTYPE);
    }

    @OverrideOnDemand
    protected boolean showEditToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE) {
        return true;
    }

    @OverrideOnDemand
    protected void modifyEditToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE, @Nonnull TOOLBAR_TYPE TOOLBAR_TYPE) {
    }

    @Nullable
    @OverrideOnDemand
    protected String getEditToolbarSubmitButtonText(@Nonnull Locale locale) {
        return EPhotonCoreText.BUTTON_SAVE.getDisplayText(locale);
    }

    @Nullable
    @OverrideOnDemand
    protected IIcon getEditToolbarSubmitButtonIcon() {
        return EDefaultIcon.SAVE;
    }

    @Nonnull
    @OverrideOnDemand
    protected TOOLBAR_TYPE createEditToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull FORM_TYPE FORM_TYPE, @Nonnull DATATYPE DATATYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        TOOLBAR_TYPE TOOLBAR_TYPE = this.createNewEditToolbar(WPECTYPE);
        TOOLBAR_TYPE.addHiddenField("action", "edit");
        TOOLBAR_TYPE.addHiddenField("object", (String)DATATYPE.getID());
        TOOLBAR_TYPE.addHiddenField("action2", "save");
        TOOLBAR_TYPE.addSubmitButton(this.getEditToolbarSubmitButtonText(locale), this.getEditToolbarSubmitButtonIcon());
        TOOLBAR_TYPE.addButtonCancel(locale);
        this.modifyEditToolbar(WPECTYPE, DATATYPE, TOOLBAR_TYPE);
        return TOOLBAR_TYPE;
    }

    @OverrideOnDemand
    protected boolean showCreateToolbar(@Nonnull WPECTYPE WPECTYPE, @Nullable DATATYPE DATATYPE) {
        return true;
    }

    @Nonnull
    @OverrideOnDemand
    protected TOOLBAR_TYPE createNewCreateToolbar(@Nonnull WPECTYPE WPECTYPE) {
        return this.getUIHandler().createToolbar((ILayoutExecutionContext)WPECTYPE);
    }

    @OverrideOnDemand
    protected void modifyCreateToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull TOOLBAR_TYPE TOOLBAR_TYPE) {
    }

    @Nullable
    @OverrideOnDemand
    protected String getCreateToolbarSubmitButtonText(@Nonnull Locale locale) {
        return EPhotonCoreText.BUTTON_SAVE.getDisplayText(locale);
    }

    @Nullable
    @OverrideOnDemand
    protected IIcon getCreateToolbarSubmitButtonIcon() {
        return EDefaultIcon.SAVE;
    }

    @Nonnull
    @OverrideOnDemand
    protected TOOLBAR_TYPE createCreateToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull FORM_TYPE FORM_TYPE, @Nullable DATATYPE DATATYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        TOOLBAR_TYPE TOOLBAR_TYPE = this.createNewCreateToolbar(WPECTYPE);
        TOOLBAR_TYPE.addHiddenField("action", "create");
        if (DATATYPE != null) {
            TOOLBAR_TYPE.addHiddenField("object", (String)DATATYPE.getID());
        }
        TOOLBAR_TYPE.addHiddenField("action2", "save");
        TOOLBAR_TYPE.addSubmitButton(this.getCreateToolbarSubmitButtonText(locale), this.getCreateToolbarSubmitButtonIcon());
        TOOLBAR_TYPE.addButtonCancel(locale);
        this.modifyCreateToolbar(WPECTYPE, TOOLBAR_TYPE);
        return TOOLBAR_TYPE;
    }

    @OverrideOnDemand
    protected boolean isActionAllowed(@Nonnull WPECTYPE WPECTYPE, @Nonnull EWebPageFormAction eWebPageFormAction, @Nullable DATATYPE DATATYPE) {
        return true;
    }

    @Nullable
    protected abstract DATATYPE getSelectedObject(@Nonnull WPECTYPE var1, @Nullable String var2);

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected boolean performLocking(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE, @Nonnull EWebPageFormAction eWebPageFormAction) {
        return eWebPageFormAction.isModifying() || eWebPageFormAction.isCustom();
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected EContinue beforeProcessing(@Nonnull WPECTYPE WPECTYPE, @Nullable DATATYPE DATATYPE, @Nonnull EWebPageFormAction eWebPageFormAction) {
        if (this.isObjectLockingEnabled()) {
            DefaultLockManager defaultLockManager = PhotonSecurityManager.getLockMgr();
            if (DATATYPE != null && this.performLocking(WPECTYPE, DATATYPE, eWebPageFormAction)) {
                String string = (String)DATATYPE.getID();
                LockResult lockResult = defaultLockManager.lockObjectAndUnlockAllOthers((Object)string);
                if (lockResult.isNotLocked()) {
                    Locale locale = WPECTYPE.getDisplayLocale();
                    HCNodeList hCNodeList = WPECTYPE.getNodeList();
                    String string2 = defaultLockManager.getLockUserID((Object)string);
                    IUser iUser = PhotonSecurityManager.getUserMgr().getUserOfID(string2);
                    String string3 = this.getObjectDisplayName(WPECTYPE, DATATYPE);
                    Object object = StringHelper.isNotEmpty((String)string3) ? " '" + string3 + "'" : "";
                    Object object2 = iUser != null ? "'" + iUser.getDisplayName() + "'" : EWebPageText.LOCKING_OTHER_USER.getDisplayText(locale);
                    hCNodeList.addChild(this.getUIHandler().createErrorBox((ILayoutExecutionContext)WPECTYPE, EWebPageText.LOCKING_FAILED.getDisplayTextWithArgs(locale, new Object[]{object, object2})));
                    return EContinue.BREAK;
                }
            } else {
                defaultLockManager.unlockAllObjectsOfCurrentUser();
            }
        }
        return EContinue.CONTINUE;
    }

    @OverrideOnDemand
    protected void afterProcessing(@Nonnull WPECTYPE WPECTYPE, @Nullable DATATYPE DATATYPE, @Nonnull EWebPageFormAction eWebPageFormAction) {
    }

    protected abstract void showSelectedObject(@Nonnull WPECTYPE var1, @Nonnull DATATYPE var2);

    protected final void handleViewObject(@Nonnull WPECTYPE WPECTYPE, @Nonnull DATATYPE DATATYPE) {
        this.showSelectedObject(WPECTYPE, DATATYPE);
        if (this.showViewToolbar(WPECTYPE, DATATYPE)) {
            WPECTYPE.getNodeList().addChild(this.createViewToolbar(WPECTYPE, true, DATATYPE));
        }
    }

    @OverrideOnDemand
    protected boolean showInputFormAgain(@Nonnull WPECTYPE WPECTYPE, @Nullable DATATYPE DATATYPE, @Nonnull FormErrorList formErrorList, @Nonnull EWebPageFormAction eWebPageFormAction) {
        return false;
    }

    @OverrideOnDemand
    protected void onInputFormFinishedSuccess(@Nonnull WPECTYPE WPECTYPE) {
    }

    @OverrideOnDemand
    protected void onInputFormError(@Nonnull WPECTYPE WPECTYPE, @Nonnull FormErrorList formErrorList) {
    }

    @OverrideOnDemand
    protected void modifyFormBeforeShowInputForm(@Nonnull WPECTYPE WPECTYPE, @Nonnull FORM_TYPE FORM_TYPE, boolean bl) {
    }

    protected abstract void showInputForm(@Nonnull WPECTYPE var1, @Nullable DATATYPE var2, @Nonnull FORM_TYPE var3, boolean var4, @Nonnull EWebPageFormAction var5, @Nonnull FormErrorList var6);

    @OverrideOnDemand
    protected void modifyFormAfterShowInputForm(@Nonnull WPECTYPE WPECTYPE, @Nonnull FORM_TYPE FORM_TYPE, boolean bl) {
    }

    protected abstract void validateAndSaveInputParameters(@Nonnull WPECTYPE var1, @Nullable DATATYPE var2, @Nonnull FormErrorList var3, @Nonnull EWebPageFormAction var4);

    protected abstract void showListOfExistingObjects(@Nonnull WPECTYPE var1);

    @Override
    protected final void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        String string = this.getSelectedObjectID(WPECTYPE);
        DATATYPE DATATYPE = this.getSelectedObject(WPECTYPE, string);
        String string2 = WPECTYPE.getAction();
        EWebPageFormAction eWebPageFormAction = EWebPageFormAction.DEFAULT;
        IWebPageActionHandler iWebPageActionHandler = null;
        if (StringHelper.isNotEmpty((String)string2)) {
            if ("view".equals(string2)) {
                if (DATATYPE != null) {
                    eWebPageFormAction = EWebPageFormAction.VIEW;
                }
            } else if ("create".equals(string2)) {
                eWebPageFormAction = EWebPageFormAction.CREATE;
            } else if ("edit".equals(string2)) {
                if (DATATYPE != null) {
                    eWebPageFormAction = EWebPageFormAction.EDIT;
                }
            } else if ("copy".equals(string2)) {
                if (DATATYPE != null) {
                    eWebPageFormAction = EWebPageFormAction.COPY;
                }
            } else if ("delete".equals(string2)) {
                if (DATATYPE != null && this.m_aDeleteHandler != null) {
                    eWebPageFormAction = EWebPageFormAction.DELETE;
                }
            } else if ("undelete".equals(string2)) {
                if (DATATYPE != null && this.m_aUndeleteHandler != null) {
                    eWebPageFormAction = EWebPageFormAction.UNDELETE;
                }
            } else {
                iWebPageActionHandler = (IWebPageActionHandler)this.m_aCustomHandlers.get((Object)string2);
                if (iWebPageActionHandler != null && (!iWebPageActionHandler.isSelectedObjectRequired() || DATATYPE != null) && iWebPageActionHandler.canHandleAction(WPECTYPE, DATATYPE)) {
                    eWebPageFormAction = EWebPageFormAction.CUSTOM;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Custom handler for page '" + this.getID() + "' and action '" + string2 + "'");
                    }
                }
            }
        }
        if (!eWebPageFormAction.isShowList() && !this.isActionAllowed(WPECTYPE, eWebPageFormAction, DATATYPE)) {
            LOGGER.warn("Action " + String.valueOf((Object)eWebPageFormAction) + " is not allowed on object " + (DATATYPE == null ? "null" : (String)DATATYPE.getID()));
            eWebPageFormAction = EWebPageFormAction.DEFAULT;
        }
        EShowList eShowList = EShowList.SHOW_LIST;
        if (this.beforeProcessing(WPECTYPE, DATATYPE, eWebPageFormAction).isContinue()) {
            switch (eWebPageFormAction) {
                case SHOW_LIST: {
                    break;
                }
                case VIEW: {
                    this.handleViewObject(WPECTYPE, DATATYPE);
                    eShowList = EShowList.DONT_SHOW_LIST;
                    break;
                }
                case CREATE: 
                case EDIT: 
                case COPY: {
                    FormErrorList formErrorList = new FormErrorList();
                    boolean bl = true;
                    boolean bl2 = WPECTYPE.hasSubAction("save");
                    if (bl2 && this.getCSRFHandler().checkCSRFNonce((IWebPageExecutionContext)WPECTYPE).isContinue()) {
                        this.validateAndSaveInputParameters(WPECTYPE, DATATYPE, formErrorList, eWebPageFormAction);
                        if (formErrorList.isEmpty()) {
                            bl = this.showInputFormAgain(WPECTYPE, DATATYPE, formErrorList, eWebPageFormAction);
                            this.onInputFormFinishedSuccess(WPECTYPE);
                        } else {
                            hCNodeList.addChild(this.getUIHandler().createIncorrectInputBox((ILayoutExecutionContext)WPECTYPE));
                            this.onInputFormError(WPECTYPE, formErrorList);
                        }
                    }
                    if (!bl) break;
                    eShowList = EShowList.DONT_SHOW_LIST;
                    FORM_TYPE FORM_TYPE = this.isFileUploadForm(WPECTYPE) ? this.getUIHandler().createFormFileUploadSelf((ILayoutExecutionContext)WPECTYPE, bl2) : this.getUIHandler().createFormSelf((ILayoutExecutionContext)WPECTYPE, bl2);
                    hCNodeList.addChild(FORM_TYPE);
                    FORM_TYPE.setID(FORM_ID_INPUT);
                    FORM_TYPE.addChild((IHCNode)this.getCSRFHandler().createCSRFNonceField());
                    this.modifyFormBeforeShowInputForm(WPECTYPE, FORM_TYPE, bl2);
                    this.showInputForm(WPECTYPE, DATATYPE, FORM_TYPE, bl2, eWebPageFormAction, formErrorList);
                    this.modifyFormAfterShowInputForm(WPECTYPE, FORM_TYPE, bl2);
                    if (eWebPageFormAction == EWebPageFormAction.EDIT) {
                        if (!this.showEditToolbar(WPECTYPE, DATATYPE)) break;
                        FORM_TYPE.addChild(this.createEditToolbar(WPECTYPE, FORM_TYPE, DATATYPE));
                        break;
                    }
                    if (!this.showCreateToolbar(WPECTYPE, DATATYPE)) break;
                    FORM_TYPE.addChild(this.createCreateToolbar(WPECTYPE, FORM_TYPE, DATATYPE));
                    break;
                }
                case DELETE: {
                    eShowList = this.m_aDeleteHandler.handleAction(WPECTYPE, DATATYPE);
                    break;
                }
                case UNDELETE: {
                    eShowList = this.m_aUndeleteHandler.handleAction(WPECTYPE, DATATYPE);
                    break;
                }
                case CUSTOM: {
                    eShowList = ((IWebPageActionHandler)this.m_aCustomHandlers.get((Object)string2)).handleAction(WPECTYPE, DATATYPE);
                }
            }
        }
        if (eShowList == EShowList.SHOW_LIST) {
            this.showListOfExistingObjects(WPECTYPE);
        }
        this.afterProcessing(WPECTYPE, DATATYPE, eWebPageFormAction);
    }
}

