/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.page;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EValidity;
import com.helger.base.state.IValidityIndicator;
import com.helger.base.string.StringHelper;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.html.traits.IHCTrait;
import com.helger.photon.ajax.GlobalAjaxInvoker;
import com.helger.photon.ajax.decl.AjaxFunctionDeclaration;
import com.helger.photon.ajax.decl.IAjaxFunctionDeclaration;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.core.page.AbstractPage;
import com.helger.photon.uicore.css.CUICoreCSS;
import com.helger.photon.uicore.page.IWebPage;
import com.helger.photon.uicore.page.IWebPageCSRFHandler;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.WebPageCSRFHandler;
import com.helger.text.IMultilingualText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public abstract class AbstractWebPage<WPECTYPE extends IWebPageExecutionContext>
extends AbstractPage
implements IWebPage<WPECTYPE>,
IHCTrait {
    protected static final ICSSClassProvider CSS_CLASS_LEFT = CUICoreCSS.CSS_CLASS_LEFT;
    protected static final ICSSClassProvider CSS_CLASS_CENTER = CUICoreCSS.CSS_CLASS_CENTER;
    protected static final ICSSClassProvider CSS_CLASS_RIGHT = CUICoreCSS.CSS_CLASS_RIGHT;
    protected static final ICSSClassProvider CSS_CLASS_NOWRAP = CUICoreCSS.CSS_CLASS_NOWRAP;
    private IWebPageCSRFHandler m_aCSRFHandler = WebPageCSRFHandler.INSTANCE;

    public AbstractWebPage(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    @Override
    @Nonnull
    public final IWebPageCSRFHandler getCSRFHandler() {
        return this.m_aCSRFHandler;
    }

    public final void setCSRFHandler(@Nonnull IWebPageCSRFHandler iWebPageCSRFHandler) {
        this.m_aCSRFHandler = (IWebPageCSRFHandler)ValueEnforcer.notNull((Object)iWebPageCSRFHandler, (String)"CSRFHandler");
    }

    @Nonnull
    @OverrideOnDemand
    protected IValidityIndicator isValidToDisplayPage(@Nonnull WPECTYPE WPECTYPE) {
        return EValidity.VALID;
    }

    @OverrideOnDemand
    protected void beforeFillContent(@Nonnull WPECTYPE WPECTYPE) {
    }

    protected abstract void fillContent(@Nonnull WPECTYPE var1);

    @OverrideOnDemand
    protected void afterFillContent(@Nonnull WPECTYPE WPECTYPE) {
    }

    @OverrideOnDemand
    protected void onInvalidToDisplayPage(@Nonnull WPECTYPE WPECTYPE) {
    }

    @Override
    public final void getContent(@Nonnull WPECTYPE WPECTYPE) {
        if (this.isValidToDisplayPage(WPECTYPE).isValid()) {
            this.beforeFillContent(WPECTYPE);
            this.fillContent(WPECTYPE);
            this.afterFillContent(WPECTYPE);
        } else {
            this.onInvalidToDisplayPage(WPECTYPE);
        }
    }

    @Nonnull
    public static final AjaxFunctionDeclaration addAjax(@Nonnull IAjaxExecutor iAjaxExecutor) {
        return AbstractWebPage.addAjax(null, iAjaxExecutor);
    }

    @Nonnull
    public static final AjaxFunctionDeclaration addAjax(@Nullable String string, @Nonnull IAjaxExecutor iAjaxExecutor) {
        String string2 = StringHelper.isNotEmpty((String)string) ? string + AjaxFunctionDeclaration.getUniqueFunctionID() : null;
        AjaxFunctionDeclaration ajaxFunctionDeclaration = AjaxFunctionDeclaration.builder((String)string2).executor(iAjaxExecutor).build();
        GlobalAjaxInvoker.getInstance().getRegistry().registerFunction((IAjaxFunctionDeclaration)ajaxFunctionDeclaration);
        return ajaxFunctionDeclaration;
    }
}

