/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.login;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.css.property.CCSSProperties;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.HCButton_Submit;
import com.helger.html.hc.html.forms.HCEdit;
import com.helger.html.hc.html.forms.HCEditPassword;
import com.helger.html.hc.html.forms.HCForm;
import com.helger.html.hc.html.forms.HCHiddenField;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.root.HCHtml;
import com.helger.html.hc.html.sections.HCBody;
import com.helger.html.hc.html.tabular.HCCol;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCell;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.textlevel.HCSpan;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.photon.core.execcontext.ISimpleWebExecutionContext;
import com.helger.photon.core.login.CLogin;
import com.helger.photon.uicore.login.AbstractLoginHTMLProvider;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public class SimpleLoginHTMLProvider
extends AbstractLoginHTMLProvider {
    public SimpleLoginHTMLProvider(boolean bl, @Nonnull ICredentialValidationResult iCredentialValidationResult) {
        super(bl, iCredentialValidationResult);
    }

    @OverrideOnDemand
    protected boolean showHeaderText() {
        return false;
    }

    @Nullable
    @OverrideOnDemand
    protected IHCNode createLabelNode(@Nullable String string) {
        return new HCTextNode(string);
    }

    @OverrideOnDemand
    protected void customizeLoginFields(@Nonnull HCTable hCTable, @Nonnull Locale locale) {
    }

    protected void fillBody(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull HCHtml hCHtml) {
        IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse = iSimpleWebExecutionContext.getRequestScope();
        Locale locale = iSimpleWebExecutionContext.getDisplayLocale();
        HCBody hCBody = hCHtml.body();
        HCSpan hCSpan = (HCSpan)hCBody.addAndReturnChild((IHCNode)((HCSpan)((HCSpan)new HCSpan().setID("login")).addStyle(CCSSProperties.MARGIN.newValue("0 auto"))));
        HCForm hCForm = (HCForm)hCSpan.addAndReturnChild((IHCNode)new HCForm((ISimpleURL)new SimpleURL(iRequestWebScopeWithoutResponse.getURLDecoded())));
        hCForm.setSubmitPressingEnter(true);
        hCForm.addChild((IHCNode)new HCHiddenField("login-action", "validate-login-credentials"));
        hCForm.addChild((IHCNode)this.getCSRFHandler().createCSRFNonceField());
        hCForm.addChild((IHCNode)new HCDiv().addClass(CLogin.CSS_CLASS_LOGIN_APPLOGO));
        if (this.showHeaderText()) {
            hCForm.addChild((IHCNode)((HCDiv)new HCDiv().addChild(this.getTextHeader(locale))).addClass(CLogin.CSS_CLASS_LOGIN_HEADER));
        }
        if (this.isLoginError()) {
            hCForm.addChild((IHCNode)((HCDiv)new HCDiv().addChild(this.getTextErrorMessage(locale, this.getLoginResult()))).addClass(CLogin.CSS_CLASS_LOGIN_ERRORMSG));
        }
        HCTable hCTable = (HCTable)hCForm.addAndReturnChild((IHCNode)new HCTable(new IHCCol[]{new HCCol(200), HCCol.star()}));
        HCRow hCRow = hCTable.addBodyRow();
        hCRow.addCell(this.createLabelNode(this.getTextFieldUserName(locale)));
        hCRow.addCell((IHCNode)new HCEdit("userid"));
        hCRow = hCTable.addBodyRow();
        hCRow.addCell(this.createLabelNode(this.getTextFieldPassword(locale)));
        hCRow.addCell((IHCNode)new HCEditPassword("password"));
        this.customizeLoginFields(hCTable, locale);
        IHCCell iHCCell = hCTable.addBodyRow().addCell().setColspan(hCTable.getColumnCount());
        iHCCell.addChild((IHCNode)new HCButton_Submit(this.getLoginButtonText(locale)));
    }
}

