/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.login;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.html.AbstractSWECHTMLProvider;
import com.helger.photon.uicore.page.IWebPageCSRFHandler;
import com.helger.photon.uicore.page.WebPageCSRFHandler;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public abstract class AbstractLoginHTMLProvider
extends AbstractSWECHTMLProvider {
    private final boolean m_bLoginError;
    private final ICredentialValidationResult m_aLoginResult;
    private IWebPageCSRFHandler m_aCSRFHandler = WebPageCSRFHandler.INSTANCE;

    public AbstractLoginHTMLProvider(boolean bl, @Nonnull ICredentialValidationResult iCredentialValidationResult) {
        this.m_bLoginError = bl;
        this.m_aLoginResult = (ICredentialValidationResult)ValueEnforcer.notNull((Object)iCredentialValidationResult, (String)"LoginResult");
    }

    public final boolean isLoginError() {
        return this.m_bLoginError;
    }

    @Nonnull
    public final ICredentialValidationResult getLoginResult() {
        return this.m_aLoginResult;
    }

    public final IWebPageCSRFHandler getCSRFHandler() {
        return this.m_aCSRFHandler;
    }

    public final void setCSRFHandler(@Nonnull IWebPageCSRFHandler iWebPageCSRFHandler) {
        this.m_aCSRFHandler = (IWebPageCSRFHandler)ValueEnforcer.notNull((Object)iWebPageCSRFHandler, (String)"CSRFHandler");
    }

    @Nullable
    @OverrideOnDemand
    protected String getTextHeader(@Nonnull Locale locale) {
        return EPhotonCoreText.LOGIN_HEADER.getDisplayText(locale);
    }

    @Nullable
    @OverrideOnDemand
    protected String getTextErrorMessage(@Nonnull Locale locale, @Nonnull ICredentialValidationResult iCredentialValidationResult) {
        return EPhotonCoreText.LOGIN_ERROR_MSG.getDisplayText(locale) + " " + iCredentialValidationResult.getDisplayText(locale);
    }

    @Nullable
    @OverrideOnDemand
    protected String getTextFieldUserName(@Nonnull Locale locale) {
        return EPhotonCoreText.LOGIN_FIELD_USERNAME.getDisplayText(locale);
    }

    @Nullable
    @OverrideOnDemand
    protected String getTextFieldPassword(@Nonnull Locale locale) {
        return EPhotonCoreText.LOGIN_FIELD_PASSWORD.getDisplayText(locale);
    }

    @Nullable
    @OverrideOnDemand
    protected String getLoginButtonText(@Nonnull Locale locale) {
        return EPhotonCoreText.LOGIN_BUTTON_SUBMIT.getDisplayText(locale);
    }
}

