/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html.toolbar;

import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.HCHiddenField;
import com.helger.html.hc.html.forms.IHCButton;
import com.helger.html.hc.html.grouping.IHCDiv;
import com.helger.html.js.IHasJSCode;
import com.helger.html.jscode.html.JSHtml;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Map;

public interface IButtonToolbar<IMPLTYPE extends IButtonToolbar<IMPLTYPE>>
extends IHCDiv<IMPLTYPE> {
    @Nonnull
    public ISimpleURL getSelfHref();

    @Nonnull
    default public IMPLTYPE addHiddenField(@Nullable String string, int n) {
        return this.addHiddenField(string, Integer.toString(n));
    }

    @Nonnull
    default public IMPLTYPE addHiddenField(@Nullable String string, @Nullable String string2) {
        this.addChild((IHCNode)new HCHiddenField(string, string2));
        return (IMPLTYPE)((IButtonToolbar)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addHiddenFields(@Nullable Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.addChild((IHCNode)new HCHiddenField(entry.getKey(), entry.getValue()));
            }
        }
        return (IMPLTYPE)((IButtonToolbar)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addButton(@Nullable String string, @Nonnull IHasJSCode iHasJSCode) {
        return this.addButton(string, iHasJSCode, (IIcon)null);
    }

    @Nonnull
    default public IMPLTYPE addButton(@Nullable String string, @Nonnull IHasJSCode iHasJSCode, @Nullable IIcon iIcon) {
        this.addAndReturnButton(string, iHasJSCode, iIcon);
        return (IMPLTYPE)((IButtonToolbar)this.thisAsT());
    }

    @Nonnull
    public IHCButton<?> addAndReturnButton(@Nullable String var1, @Nullable IHasJSCode var2, @Nullable IIcon var3);

    @Nonnull
    default public IMPLTYPE addButton(@Nullable String string, @Nullable ISimpleURL iSimpleURL) {
        return this.addButton(string, iSimpleURL, (IIcon)null);
    }

    @Nonnull
    default public IMPLTYPE addButton(@Nullable String string, @Nullable ISimpleURL iSimpleURL, @Nullable IIcon iIcon) {
        this.addAndReturnButton(string, iSimpleURL, iIcon);
        return (IMPLTYPE)((IButtonToolbar)this.thisAsT());
    }

    @Nonnull
    default public IHCButton<?> addAndReturnButton(@Nullable String string, @Nullable ISimpleURL iSimpleURL, @Nullable IIcon iIcon) {
        return this.addAndReturnButton(string, (IHasJSCode)(iSimpleURL == null ? null : JSHtml.windowLocationHref((ISimpleURL)iSimpleURL)), iIcon);
    }

    @Nonnull
    default public IMPLTYPE addButtonBack(@Nonnull Locale locale, @Nonnull ISimpleURL iSimpleURL) {
        return this.addButton(EPhotonCoreText.BUTTON_BACK.getDisplayText(locale), iSimpleURL, (IIcon)EDefaultIcon.BACK);
    }

    @Nonnull
    default public IMPLTYPE addButtonBack(@Nonnull Locale locale, @Nonnull IHasJSCode iHasJSCode) {
        return this.addButton(EPhotonCoreText.BUTTON_BACK.getDisplayText(locale), iHasJSCode, (IIcon)EDefaultIcon.BACK);
    }

    @Nonnull
    default public IMPLTYPE addButtonBack(@Nonnull Locale locale) {
        return this.addButtonBack(locale, this.getSelfHref());
    }

    @Nonnull
    default public IMPLTYPE addButtonCancel(@Nonnull Locale locale, @Nonnull ISimpleURL iSimpleURL) {
        return this.addButton(EPhotonCoreText.BUTTON_CANCEL.getDisplayText(locale), iSimpleURL, (IIcon)EDefaultIcon.CANCEL);
    }

    @Nonnull
    default public IMPLTYPE addButtonCancel(@Nonnull Locale locale, @Nonnull IHasJSCode iHasJSCode) {
        return this.addButton(EPhotonCoreText.BUTTON_CANCEL.getDisplayText(locale), iHasJSCode, (IIcon)EDefaultIcon.CANCEL);
    }

    @Nonnull
    default public IMPLTYPE addButtonCancel(@Nonnull Locale locale) {
        return this.addButtonCancel(locale, this.getSelfHref());
    }

    @Nonnull
    default public IMPLTYPE addButtonNo(@Nonnull Locale locale, @Nonnull ISimpleURL iSimpleURL) {
        return this.addButton(EPhotonCoreText.BUTTON_NO.getDisplayText(locale), iSimpleURL, (IIcon)EDefaultIcon.NO);
    }

    @Nonnull
    default public IMPLTYPE addButtonNo(@Nonnull Locale locale, @Nonnull IHasJSCode iHasJSCode) {
        return this.addButton(EPhotonCoreText.BUTTON_NO.getDisplayText(locale), iHasJSCode, (IIcon)EDefaultIcon.NO);
    }

    @Nonnull
    default public IMPLTYPE addButtonNo(@Nonnull Locale locale) {
        return this.addButtonNo(locale, this.getSelfHref());
    }

    @Nonnull
    default public IMPLTYPE addButtonEdit(@Nonnull Locale locale, @Nonnull ISimpleURL iSimpleURL) {
        return this.addButton(EPhotonCoreText.BUTTON_EDIT.getDisplayText(locale), iSimpleURL, (IIcon)EDefaultIcon.EDIT);
    }

    @Nonnull
    default public IMPLTYPE addButtonEdit(@Nonnull Locale locale, @Nonnull IHasJSCode iHasJSCode) {
        return this.addButton(EPhotonCoreText.BUTTON_EDIT.getDisplayText(locale), iHasJSCode, (IIcon)EDefaultIcon.EDIT);
    }

    @Nonnull
    default public IMPLTYPE addButtonSave(@Nonnull Locale locale, @Nonnull ISimpleURL iSimpleURL) {
        return this.addButton(EPhotonCoreText.BUTTON_SAVE.getDisplayText(locale), iSimpleURL, (IIcon)EDefaultIcon.SAVE);
    }

    @Nonnull
    default public IMPLTYPE addButtonSave(@Nonnull Locale locale, @Nonnull IHasJSCode iHasJSCode) {
        return this.addButton(EPhotonCoreText.BUTTON_SAVE.getDisplayText(locale), iHasJSCode, (IIcon)EDefaultIcon.SAVE);
    }

    @Nonnull
    default public IMPLTYPE addButtonNew(@Nullable String string, @Nonnull ISimpleURL iSimpleURL) {
        return this.addButton(string, iSimpleURL, (IIcon)EDefaultIcon.NEW);
    }

    @Nonnull
    default public IMPLTYPE addSubmitButton(@Nullable String string) {
        return this.addSubmitButton(string, null, null);
    }

    @Nonnull
    default public IMPLTYPE addSubmitButton(@Nullable String string, @Nullable IHasJSCode iHasJSCode) {
        return this.addSubmitButton(string, iHasJSCode, null);
    }

    @Nonnull
    default public IMPLTYPE addSubmitButton(@Nullable String string, @Nullable IIcon iIcon) {
        this.addAndReturnSubmitButton(string, null, iIcon);
        return (IMPLTYPE)((IButtonToolbar)this.thisAsT());
    }

    @Nonnull
    public IHCButton<?> addAndReturnSubmitButton(@Nullable String var1, @Nullable IHasJSCode var2, @Nullable IIcon var3);

    @Nonnull
    default public IMPLTYPE addSubmitButton(@Nullable String string, @Nullable IHasJSCode iHasJSCode, @Nullable IIcon iIcon) {
        this.addAndReturnSubmitButton(string, iHasJSCode, iIcon);
        return (IMPLTYPE)((IButtonToolbar)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addSubmitButtonSave(@Nonnull Locale locale) {
        return this.addSubmitButton(EPhotonCoreText.BUTTON_SAVE.getDisplayText(locale), EDefaultIcon.SAVE);
    }

    @Nonnull
    default public IMPLTYPE addSubmitButtonYes(@Nonnull Locale locale) {
        return this.addSubmitButton(EPhotonCoreText.BUTTON_YES.getDisplayText(locale), EDefaultIcon.YES);
    }
}

