/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html.tabbox;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.hc.IHCNode;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;

public class Tab
implements IHasID<String>,
Serializable {
    private final String m_sID;
    private final boolean m_bHasGeneratedID;
    private IHCNode m_aLabel;
    private IHCNode m_aContent;
    private boolean m_bDisabled;

    public Tab(@Nullable String string, @Nullable IHCNode iHCNode, @Nullable IHCNode iHCNode2, boolean bl) {
        if (StringHelper.isNotEmpty((String)string)) {
            this.m_sID = string;
            this.m_bHasGeneratedID = false;
        } else {
            this.m_sID = GlobalIDFactory.getNewStringID();
            this.m_bHasGeneratedID = true;
        }
        this.m_aLabel = iHCNode;
        this.m_aContent = iHCNode2;
        this.m_bDisabled = bl;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    public boolean isGeneratedID() {
        return this.m_bHasGeneratedID;
    }

    @Nonnull
    public ISimpleURL getLinkURL() {
        return new SimpleURL().setAnchor(this.m_sID);
    }

    @Nullable
    public IHCNode getLabel() {
        return this.m_aLabel;
    }

    @Nonnull
    public Tab setLabel(@Nullable IHCNode iHCNode) {
        this.m_aLabel = iHCNode;
        return this;
    }

    @Nullable
    public IHCNode getContent() {
        return this.m_aContent;
    }

    @Nonnull
    public Tab setContent(@Nullable IHCNode iHCNode) {
        this.m_aContent = iHCNode;
        return this;
    }

    public boolean isDisabled() {
        return this.m_bDisabled;
    }

    @Nonnull
    public Tab setDisabled(boolean bl) {
        this.m_bDisabled = bl;
        return this;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("generatedID", this.m_bHasGeneratedID).append("label", (Object)this.m_aLabel).append("content", (Object)this.m_aContent).append("disabled", this.m_bDisabled).getToString();
    }
}

