/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html.tabbox;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.impl.AbstractHCNodeList;
import com.helger.photon.uicore.html.tabbox.ITabBox;
import com.helger.photon.uicore.html.tabbox.Tab;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTabBox<IMPLTYPE extends AbstractTabBox<IMPLTYPE>>
extends AbstractHCNodeList<IMPLTYPE>
implements ITabBox<IMPLTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTabBox.class);
    protected final ICommonsOrderedMap<String, Tab> m_aTabs = new CommonsLinkedHashMap();
    private String m_sActiveTabID;

    @Override
    public String getActiveTabID() {
        return this.m_sActiveTabID;
    }

    @Override
    @Nonnull
    public IMPLTYPE setActiveTabID(@Nullable String string) {
        this.m_sActiveTabID = string;
        if (StringHelper.isNotEmpty((String)string) && !this.m_aTabs.containsKey((Object)string)) {
            LOGGER.warn("No tab with ID '" + string + "' to be set active!");
        }
        return (IMPLTYPE)((AbstractTabBox)this.thisAsT());
    }

    @Override
    @Nonnull
    public Tab addTab(@Nullable String string, @Nullable IHCNode iHCNode, @Nullable IHCNode iHCNode2, boolean bl, boolean bl2) {
        Tab tab = new Tab(string, iHCNode, iHCNode2, bl2);
        this.addTab(tab, bl);
        return tab;
    }

    @Override
    @Nonnull
    public IMPLTYPE addTab(@Nonnull Tab tab, boolean bl) {
        ValueEnforcer.notNull((Object)tab, (String)"Tab");
        String string = tab.getID();
        this.m_aTabs.put((Object)string, (Object)tab);
        if (bl) {
            this.m_sActiveTabID = string;
        }
        return (IMPLTYPE)((AbstractTabBox)this.thisAsT());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Tab> getAllTabs() {
        return this.m_aTabs.copyOfValues();
    }

    @Override
    @Nullable
    public Tab getTabOfID(@Nullable String string) {
        return (Tab)this.m_aTabs.get((Object)string);
    }

    @Override
    @Nullable
    public Tab getActiveTab() {
        Tab tab = null;
        if (this.m_sActiveTabID != null) {
            tab = this.getTabOfID(this.m_sActiveTabID);
        }
        return tab;
    }

    @Override
    @Nullable
    public Tab getActiveTabOrDefault() {
        Tab tab = this.getActiveTab();
        if (tab == null) {
            tab = (Tab)this.m_aTabs.getFirstValue();
        }
        return tab;
    }

    @Override
    public boolean hasTabs() {
        return this.m_aTabs.isNotEmpty();
    }

    @Override
    public boolean hasNoTabs() {
        return this.m_aTabs.isEmpty();
    }

    @Override
    @Nonnegative
    public int getTabCount() {
        return this.m_aTabs.size();
    }

    @Override
    @Nonnull
    public EChange removeTab(@Nullable String string) {
        if (this.m_aTabs.remove((Object)string) == null) {
            return EChange.UNCHANGED;
        }
        if (this.m_sActiveTabID != null && this.m_sActiveTabID.equals(string)) {
            this.m_sActiveTabID = null;
        }
        return EChange.CHANGED;
    }

    @Override
    public void sortTabs(@Nonnull Comparator<? super Tab> comparator) {
        ValueEnforcer.notNull(comparator, (String)"Comparator");
        this.m_aTabs.setAll((Map)this.m_aTabs.getSortedByValue(comparator));
    }
}

