/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html.select;

import com.helger.collection.commons.ICommonsMap;
import com.helger.html.request.IHCRequestField;
import com.helger.masterdata.vat.IVATItem;
import com.helger.masterdata.vat.VATManager;
import com.helger.photon.uicore.html.select.HCExtSelect;
import jakarta.annotation.Nonnull;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;

public class HCVATItemSelect
extends HCExtSelect {
    public HCVATItemSelect(@Nonnull IHCRequestField iHCRequestField, @Nonnull Locale locale, @Nonnull Locale locale2, boolean bl) {
        this(iHCRequestField, VATManager.getDefaultInstance(), locale, locale2, bl);
    }

    public HCVATItemSelect(@Nonnull IHCRequestField iHCRequestField, @Nonnull VATManager vATManager, @Nonnull Locale locale, @Nonnull Locale locale2, boolean bl) {
        super(iHCRequestField);
        ICommonsMap iCommonsMap;
        if (bl) {
            this.addOptionPleaseSelect(locale2);
        }
        if (!(iCommonsMap = vATManager.getAllVATItemsForCountry(locale)).containsKey(VATManager.VATTYPE_NONE.getID())) {
            iCommonsMap.put((Object)((String)VATManager.VATTYPE_NONE.getID()), (Object)VATManager.VATTYPE_NONE);
        }
        for (Map.Entry entry : iCommonsMap.getSortedByValue(Comparator.comparing(IVATItem::getPercentage)).entrySet()) {
            IVATItem iVATItem = (IVATItem)entry.getValue();
            if (iVATItem.isDeprecated()) continue;
            String string = iVATItem.getDisplayText(locale2);
            this.addOption((String)entry.getKey(), string);
        }
    }
}

