/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html.select;

import com.helger.collection.commons.ICommonsList;
import com.helger.html.request.IHCRequestField;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.user.IUser;
import com.helger.photon.uicore.html.select.HCExtSelect;
import com.helger.text.compare.ComparatorHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;

public class HCUserSelect
extends HCExtSelect {
    public static final Function<? super IUser, String> DEFAULT_DISPLAY_TEXT_PROVIDER = iUser -> iUser.getDisplayName() + " (" + iUser.getLoginName() + ")";

    public HCUserSelect(@Nonnull IHCRequestField iHCRequestField, @Nonnull Locale locale, @Nullable Predicate<? super IUser> predicate) {
        this(iHCRequestField, locale, predicate, DEFAULT_DISPLAY_TEXT_PROVIDER);
    }

    public HCUserSelect(@Nonnull IHCRequestField iHCRequestField, @Nonnull Locale locale, @Nullable Predicate<? super IUser> predicate, @Nonnull Function<? super IUser, String> function) {
        this(iHCRequestField, (ICommonsList<? extends IUser>)PhotonSecurityManager.getUserMgr().getAllActiveUsers().getSortedInline(ComparatorHelper.getComparatorCollating(IUser::getDisplayName, (Locale)locale)), predicate, function);
    }

    public HCUserSelect(@Nonnull IHCRequestField iHCRequestField, @Nonnull ICommonsList<? extends IUser> iCommonsList, @Nullable Predicate<? super IUser> predicate, @Nonnull Function<? super IUser, String> function) {
        super(iHCRequestField);
        for (IUser iUser : iCommonsList) {
            if (predicate != null && !predicate.test((IUser)iUser)) continue;
            this.addOption((String)iUser.getID(), function.apply((IUser)iUser));
        }
    }
}

