/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html.select;

import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.helper.CollectionSort;
import com.helger.html.request.IHCRequestField;
import com.helger.masterdata.locale.DeprecatedLocaleHandler;
import com.helger.photon.uicore.html.select.HCExtSelect;
import com.helger.text.compare.ComparatorHelper;
import com.helger.text.display.IDisplayTextProvider;
import com.helger.text.locale.country.CountryCache;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.Locale;

public class HCCountrySelect
extends HCExtSelect {
    @Nonnull
    public static ICommonsList<Locale> getAllCountries(@Nonnull EWithDeprecated eWithDeprecated) {
        boolean bl = eWithDeprecated.isWithDeprecated();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Locale locale : CountryCache.getInstance().getAllCountryLocales()) {
            if (!bl && DeprecatedLocaleHandler.getDefaultInstance().isDeprecatedLocaleWithFallback(locale)) continue;
            commonsArrayList.add((Object)locale);
        }
        return commonsArrayList;
    }

    public HCCountrySelect(@Nonnull IHCRequestField iHCRequestField, @Nonnull Locale locale) {
        this(iHCRequestField, locale, EWithDeprecated.DEFAULT);
    }

    public HCCountrySelect(@Nonnull IHCRequestField iHCRequestField, @Nonnull Locale locale, @Nonnull EWithDeprecated eWithDeprecated) {
        this(iHCRequestField, locale, (Iterable<? extends Locale>)HCCountrySelect.getAllCountries(eWithDeprecated));
    }

    public HCCountrySelect(@Nonnull IHCRequestField iHCRequestField, @Nonnull Locale locale, boolean bl) {
        this(iHCRequestField, locale, EWithDeprecated.DEFAULT, bl);
    }

    public HCCountrySelect(@Nonnull IHCRequestField iHCRequestField, @Nonnull Locale locale, @Nonnull EWithDeprecated eWithDeprecated, boolean bl) {
        this(iHCRequestField, locale, (Iterable<? extends Locale>)HCCountrySelect.getAllCountries(eWithDeprecated), null, bl);
    }

    public HCCountrySelect(@Nonnull IHCRequestField iHCRequestField, @Nonnull Locale locale, @Nonnull Iterable<? extends Locale> iterable) {
        this(iHCRequestField, locale, iterable, null);
    }

    public HCCountrySelect(@Nonnull IHCRequestField iHCRequestField, @Nonnull Locale locale, @Nonnull Iterable<? extends Locale> iterable, @Nullable IDisplayTextProvider<Locale> iDisplayTextProvider) {
        this(iHCRequestField, locale, iterable, iDisplayTextProvider, true);
    }

    public HCCountrySelect(@Nonnull IHCRequestField iHCRequestField, @Nonnull Locale locale, @Nonnull Iterable<? extends Locale> iterable, @Nullable IDisplayTextProvider<Locale> iDisplayTextProvider, boolean bl) {
        super(iHCRequestField);
        Comparator comparator = iDisplayTextProvider == null ? ComparatorHelper.getComparatorCollating(locale2 -> locale2.getDisplayCountry(locale), (Locale)locale) : iDisplayTextProvider.getComparatorCollating(locale, locale);
        for (Locale locale3 : CollectionSort.getSorted(iterable, (Comparator)comparator)) {
            String string = iDisplayTextProvider != null ? iDisplayTextProvider.getDisplayText((Object)locale3, locale) : locale3.getDisplayCountry(locale);
            this.addOption(locale3.getCountry(), string);
        }
        if (!this.hasSelectedOption() || bl) {
            this.addOptionPleaseSelect(locale);
        }
    }

    public static enum EWithDeprecated {
        TRUE,
        FALSE;

        public static final EWithDeprecated DEFAULT;

        public boolean isWithDeprecated() {
            return this == TRUE;
        }

        static {
            DEFAULT = FALSE;
        }
    }
}

