/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html.select;

import com.helger.base.charset.CharsetHelper;
import com.helger.html.request.IHCRequestField;
import com.helger.photon.uicore.html.select.HCExtSelect;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.function.Predicate;

public class HCCharsetSelect
extends HCExtSelect {
    public HCCharsetSelect(@Nonnull IHCRequestField iHCRequestField, boolean bl, @Nonnull Locale locale) {
        this(iHCRequestField, charset -> charset.isRegistered() || !bl, locale);
    }

    public HCCharsetSelect(@Nonnull IHCRequestField iHCRequestField, @Nullable Predicate<? super Charset> predicate, @Nonnull Locale locale) {
        super(iHCRequestField);
        for (Charset charset : CharsetHelper.getAllCharsets().values()) {
            if (predicate != null && !predicate.test(charset)) continue;
            this.addOption(charset.name(), charset.displayName(locale));
        }
        this.addOptionPleaseSelect(locale);
    }
}

