/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html.google;

import com.helger.annotation.Nonempty;
import com.helger.base.CGlobal;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHelper;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.HttpClientSettings;
import com.helger.httpclient.response.ResponseHandlerJson;
import com.helger.json.IJson;
import com.helger.url.SimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReCaptchaServerSideValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReCaptchaServerSideValidator.class);

    private ReCaptchaServerSideValidator() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static ESuccess check(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull HttpClientSettings httpClientSettings) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ServerSideKey");
        ValueEnforcer.notNull((Object)httpClientSettings, (String)"HttpClientSettings");
        if (StringHelper.isEmpty((String)string2)) {
            return ESuccess.SUCCESS;
        }
        try (HttpClientManager httpClientManager = HttpClientManager.create((HttpClientSettings)httpClientSettings);){
            HttpPost httpPost = new HttpPost(new SimpleURL("https://www.google.com/recaptcha/api/siteverify").add("secret", string).add("response", string2).getAsURI());
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(CGlobal.EMPTY_BYTE_ARRAY, ContentType.APPLICATION_JSON));
            ResponseHandlerJson responseHandlerJson = new ResponseHandlerJson();
            IJson iJson = (IJson)httpClientManager.execute((HttpUriRequest)httpPost, (HttpClientResponseHandler)responseHandlerJson);
            if (iJson == null) return ESuccess.FAILURE;
            if (!iJson.isObject()) return ESuccess.FAILURE;
            boolean bl = iJson.getAsObject().getAsBoolean((Object)"success", false);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ReCpatcha Response for '" + string2 + "': " + iJson.getAsJsonString());
            }
            ESuccess eSuccess = ESuccess.valueOf((boolean)bl);
            return eSuccess;
        }
        catch (IOException iOException) {
            LOGGER.warn("Error checking ReCaptcha response", (Throwable)iOException);
        }
        return ESuccess.FAILURE;
    }
}

