/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html.google;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.AbstractHCDiv;
import com.helger.html.hc.html.script.HCScriptInline;
import com.helger.html.js.IHasJSCode;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSFunction;
import com.helger.html.jscode.html.JSHtml;
import com.helger.html.resource.js.ConstantJSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonJS;
import com.helger.url.SimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class HCReCaptchaV3
extends AbstractHCDiv<HCReCaptchaV3> {
    public static final ICSSClassProvider CSS_G_RECAPTCHA = DefaultCSSClassProvider.create((String)"g-recaptcha");
    public static final String RESPONSE_PARAMETER_NAME = "g-recaptcha-response";
    private final String m_sFunctionName;
    private final String m_sDisplayLanguage;
    private final String m_sFormID;

    public HCReCaptchaV3(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull String string3) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SiteKey");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"FormID");
        this.m_sFunctionName = "onRecaptchaSubmit" + GlobalIDFactory.getNewIntID();
        this.addClass(CSS_G_RECAPTCHA);
        this.customAttrs().setDataAttr("sitekey", string);
        this.customAttrs().setDataAttr("callback", this.m_sFunctionName);
        this.customAttrs().setDataAttr("action", "submit");
        this.m_sDisplayLanguage = string2;
        this.m_sFormID = string3;
    }

    @Nullable
    public final String getDisplayLanguage() {
        return this.m_sDisplayLanguage;
    }

    protected void onFinalizeNodeState(IHCConversionSettingsToNode iHCConversionSettingsToNode, IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        JSFunction jSFunction = new JSFunction(this.m_sFunctionName);
        jSFunction.body().add((IJSStatement)JSHtml.documentGetElementById((String)this.m_sFormID).invoke("submit"));
        iHCHasChildrenMutable.addChild((IHCNode)new HCScriptInline((IHasJSCode)jSFunction));
    }

    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        super.onRegisterExternalResources(iHCConversionSettingsToNode, bl);
        SimpleURL simpleURL = new SimpleURL("https://www.google.com/recaptcha/api.js");
        if (this.m_sDisplayLanguage != null) {
            simpleURL.add("hl", this.m_sDisplayLanguage);
        }
        String string = simpleURL.getAsString();
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)ConstantJSPathProvider.builder().path(string).minifiedPath(string).bundlable(false).build());
    }
}

