/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html.google;

import com.helger.annotation.Nonempty;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.css.property.CCSSProperties;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.AbstractHCButton;
import com.helger.html.hc.html.forms.IHCForm;
import com.helger.html.hc.html.script.HCScriptInline;
import com.helger.html.js.IHasJSCode;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSFunction;
import com.helger.html.jscode.html.JSHtml;
import com.helger.html.resource.js.ConstantJSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonJS;
import jakarta.annotation.Nonnull;

public class HCReCaptchaInvisible
extends AbstractHCButton<HCReCaptchaInvisible> {
    public static final ICSSClassProvider CSS_G_RECAPTCHA = DefaultCSSClassProvider.create((String)"g-recaptcha");

    public HCReCaptchaInvisible(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SiteKey");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"ProgressCallbackFn");
        this.addClass(CSS_G_RECAPTCHA);
        this.customAttrs().setDataAttr("sitekey", string);
        this.customAttrs().setDataAttr("callback", string2);
        this.addStyle(CCSSProperties.DISPLAY_NONE);
    }

    public boolean canConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        return GlobalDebug.isProductionMode();
    }

    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        super.onRegisterExternalResources(iHCConversionSettingsToNode, bl);
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)ConstantJSPathProvider.builder().path("https://www.google.com/recaptcha/api.js").minifiedPath("https://www.google.com/recaptcha/api.js").bundlable(false).build());
    }

    @Nonnull
    public static HCReCaptchaInvisible createForFormSubmit(@Nonnull @Nonempty String string, @Nonnull IHCForm<?> iHCForm) {
        String string2 = "jsrc" + GlobalIDFactory.getNewIntID();
        HCReCaptchaInvisible hCReCaptchaInvisible = new HCReCaptchaInvisible(string, string2);
        JSFunction jSFunction = new JSFunction(string2);
        jSFunction.body().add((IJSStatement)JSHtml.documentGetElementById((String)((IHCForm)iHCForm.ensureID()).getID()).invoke("submit"));
        hCReCaptchaInvisible.addChild((IHCNode)new HCScriptInline((IHasJSCode)jSFunction));
        return hCReCaptchaInvisible;
    }
}

