/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html.google;

import com.helger.annotation.Nonempty;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.annotation.OutOfBandNode;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.script.AbstractHCScriptInline;
import com.helger.html.js.IHasJSCode;
import com.helger.html.jscode.IJSAssignmentTarget;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSFunction;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.jscode.JSPackage;
import com.helger.html.jscode.html.JSHtml;
import com.helger.html.jscode.type.JSTypeDate;
import com.helger.html.resource.js.ConstantJSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonJS;
import com.helger.url.SimpleURL;
import jakarta.annotation.Nonnull;

@OutOfBandNode
public class HCGoogleAnalyticsV4
extends AbstractHCScriptInline<HCGoogleAnalyticsV4> {
    public static final String URL_GTAG = "https://www.googletagmanager.com/gtag/js";
    private final String m_sTagID;

    @Nonnull
    private static JSPackage _createJSCode(@Nonnull @Nonempty String string) {
        JSPackage jSPackage = new JSPackage();
        jSPackage.assign((IJSAssignmentTarget)JSHtml.window().ref("dataLayer"), JSHtml.window().ref("dataLayer").cor((IJSExpression)new JSArray()));
        JSFunction jSFunction = jSPackage.function("gtag");
        jSFunction.body().add((IJSStatement)JSExpr.ref((String)"dataLayer").invoke("push").args(new IJSExpression[]{JSExpr.ref((String)"arguments")}));
        ((JSInvocation)jSPackage.invoke(jSFunction).arg("js")).arg((IJSExpression)new JSTypeDate()._new());
        ((JSInvocation)jSPackage.invoke(jSFunction).arg("config")).arg(string);
        return jSPackage;
    }

    public HCGoogleAnalyticsV4(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"TagID");
        this.m_sTagID = string;
    }

    @Nonnull
    @Nonempty
    public String getTagID() {
        return this.m_sTagID;
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.setJSCodeProvider((IHasJSCode)HCGoogleAnalyticsV4._createJSCode(this.m_sTagID));
    }

    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        super.onRegisterExternalResources(iHCConversionSettingsToNode, bl);
        String string = new SimpleURL(URL_GTAG).add("id", this.m_sTagID).getAsString();
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)ConstantJSPathProvider.builder().path(string).minifiedPath(string).bundlable(false).build());
    }
}

