/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html.formlabel;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsEnumMap;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.html.hc.HCHelper;
import com.helger.html.hc.IHCNodeWithChildren;
import com.helger.photon.uicore.html.formlabel.ELabelType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class HCFormLabelHelper {
    public static final String DEFAULT_SIGN_OPTIONAL = "";
    public static final String DEFAULT_SIGN_MANDATORY = "*";
    public static final String DEFAULT_SIGN_ALTERNATIVE = "\u00b0";
    public static final String DEFAULT_LABEL_END = ":";
    private static final Logger LOGGER = LoggerFactory.getLogger(HCFormLabelHelper.class);
    private static final Map<ELabelType, String> DEFAULT_SUFFIXES = new CommonsEnumMap(ELabelType.class);
    private static String s_sDefaultLabelEnd;

    private HCFormLabelHelper() {
    }

    public static void resetToDefault(boolean bl) {
        s_sDefaultLabelEnd = DEFAULT_LABEL_END;
        DEFAULT_SUFFIXES.clear();
        DEFAULT_SUFFIXES.put(ELabelType.OPTIONAL, DEFAULT_SIGN_OPTIONAL);
        DEFAULT_SUFFIXES.put(ELabelType.MANDATORY, DEFAULT_SIGN_MANDATORY);
        DEFAULT_SUFFIXES.put(ELabelType.ALTERNATIVE, DEFAULT_SIGN_ALTERNATIVE);
        if (bl) {
            LOGGER.info("The UI label configuration was reset to default");
        }
    }

    @Nonnull
    public static String getDefaultLabelEnd() {
        return s_sDefaultLabelEnd;
    }

    public static void setDefaultLabelEnd(@Nullable String string) {
        String string2;
        s_sDefaultLabelEnd = string2 = StringHelper.getNotNull((String)string);
        LOGGER.info("The UI default 'label end' was set to '" + string2 + "'");
    }

    @Nullable
    public static String getSuffixStringOrNull(@Nonnull ELabelType eLabelType) {
        return DEFAULT_SUFFIXES.get((Object)eLabelType);
    }

    @Nonnull
    public static String getSuffixString(@Nonnull ELabelType eLabelType) {
        return StringHelper.getNotNull((String)HCFormLabelHelper.getSuffixStringOrNull(eLabelType));
    }

    public static void setDefaultSuffixString(@Nonnull ELabelType eLabelType, @Nullable String string) {
        ValueEnforcer.notNull((Object)((Object)eLabelType), (String)"Type");
        String string2 = StringHelper.getNotNull((String)string);
        DEFAULT_SUFFIXES.put(eLabelType, string2);
        LOGGER.info("The UI default suffix for type " + String.valueOf((Object)eLabelType) + " was set to '" + string2 + "'");
    }

    @Nonnull
    public static String getSuffix(@Nonnull ELabelType eLabelType, boolean bl) {
        String string = HCFormLabelHelper.getSuffixString(eLabelType);
        return bl ? string + HCFormLabelHelper.getDefaultLabelEnd() : string;
    }

    private static boolean _isNoLabelEndNeeded(@Nonnull ELabelType eLabelType, @Nonnull String string) {
        if (eLabelType == ELabelType.NONE) {
            return true;
        }
        return StringHelper.endsWith((CharSequence)string, (char)'?');
    }

    @Nonnull
    private static String _getTextToAppend(@Nonnull ELabelType eLabelType, @Nonnull String string) {
        String string2 = HCFormLabelHelper.getSuffixString(eLabelType);
        String string3 = HCFormLabelHelper.getDefaultLabelEnd();
        if (StringHelper.isNotEmpty((String)string2) && StringHelper.endsWith((String)string, (String)string2)) {
            return string3;
        }
        if (StringHelper.isNotEmpty((String)string3)) {
            if (!StringHelper.endsWith((String)string, (String)string3)) {
                if (HCFormLabelHelper._isNoLabelEndNeeded(eLabelType, string)) {
                    return string2;
                }
                return string2 + string3;
            }
        } else {
            return string2;
        }
        return DEFAULT_SIGN_OPTIONAL;
    }

    @Nonnull
    public static String getTextWithState(@Nonnull String string, @Nonnull ELabelType eLabelType) {
        ValueEnforcer.notNull((Object)string, (String)"Text");
        ValueEnforcer.notNull((Object)((Object)eLabelType), (String)"Type");
        Object object = string;
        if (StringHelper.isNotEmpty((String)object)) {
            object = (String)object + HCFormLabelHelper._getTextToAppend(eLabelType, (String)object);
        }
        return object;
    }

    @Nonnull
    public static <T extends IHCNodeWithChildren<?>> T getNodeWithState(@Nonnull T t, @Nonnull ELabelType eLabelType) {
        String string;
        String string2;
        ValueEnforcer.notNull(t, (String)"Node");
        ValueEnforcer.notNull((Object)((Object)eLabelType), (String)"Type");
        if (HCHelper.recursiveContainsAtLeastOneTextNode(t) && (string2 = t.getPlainText()).length() > 0 && !(string = HCFormLabelHelper._getTextToAppend(eLabelType, string2)).isEmpty()) {
            t.addChild(string);
        }
        return t;
    }

    @Nullable
    public static String trimAllKnownSuffixes(@Nullable String string) {
        boolean bl;
        String string22;
        if (StringHelper.isEmpty((String)string)) {
            return string;
        }
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        for (String string22 : DEFAULT_SUFFIXES.values()) {
            if (!StringHelper.isNotEmpty((String)string22)) continue;
            commonsHashSet.add((Object)string22);
        }
        String string3 = HCFormLabelHelper.getDefaultLabelEnd();
        if (StringHelper.isNotEmpty((String)string3)) {
            commonsHashSet.add((Object)string3);
        }
        string22 = string;
        block1: do {
            bl = false;
            for (String string4 : commonsHashSet) {
                String string5 = StringHelper.trimEnd((String)string22, (String)string4);
                if (string5.length() == string22.length()) continue;
                bl = true;
                string22 = string5;
                continue block1;
            }
        } while (bl);
        return string22;
    }

    static {
        HCFormLabelHelper.resetToDefault(false);
    }
}

