/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html.formlabel;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.IHCNodeWithChildren;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.IHCElementWithChildren;
import com.helger.html.hc.html.forms.AbstractHCLabel;
import com.helger.html.hc.html.textlevel.HCSpan;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.photon.uicore.html.formlabel.ELabelType;
import com.helger.photon.uicore.html.formlabel.HCFormLabelHelper;
import com.helger.photon.uicore.html.formlabel.IFormLabel;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class HCFormLabel
extends AbstractHCLabel<HCFormLabel>
implements IFormLabel {
    public static final ICSSClassProvider CSS_CLASS_FORM_LABEL = DefaultCSSClassProvider.create((String)"form-label");
    private final ELabelType m_eType;
    private final boolean m_bTextLabel;
    private final String m_sPlainText;

    public static void assignFormLabelClasses(@Nonnull IHCElement<?> iHCElement, @Nonnull ELabelType eLabelType) {
        ((IHCElement)iHCElement.addClass(CSS_CLASS_FORM_LABEL)).addClass(eLabelType.getCSSClass());
    }

    public HCFormLabel(@Nullable IHCNode iHCNode) {
        this.m_eType = ELabelType.NONE;
        this.m_bTextLabel = false;
        this.m_sPlainText = iHCNode != null ? iHCNode.getPlainText() : "";
        this.addChild(iHCNode);
    }

    public HCFormLabel(@Nonnull String string, @Nonnull ELabelType eLabelType) {
        ValueEnforcer.notNull((Object)string, (String)"Text");
        ValueEnforcer.notNull((Object)((Object)eLabelType), (String)"Type");
        HCFormLabel.assignFormLabelClasses(this, eLabelType);
        String string2 = StringHelper.trimEnd((String)string.trim(), (String)HCFormLabelHelper.getDefaultLabelEnd());
        String string3 = HCFormLabelHelper.getTextWithState(string2, eLabelType);
        this.addChild((IHCNode)new HCTextNode(string3));
        this.m_eType = eLabelType;
        this.m_bTextLabel = true;
        this.m_sPlainText = string2;
    }

    public HCFormLabel(@Nonnull IHCNodeWithChildren<?> iHCNodeWithChildren, @Nonnull ELabelType eLabelType) {
        ValueEnforcer.notNull(iHCNodeWithChildren, (String)"Node");
        ValueEnforcer.notNull((Object)((Object)eLabelType), (String)"Type");
        HCFormLabel.assignFormLabelClasses(this, eLabelType);
        this.m_eType = eLabelType;
        this.m_bTextLabel = false;
        this.m_sPlainText = StringHelper.trimEnd((String)iHCNodeWithChildren.getPlainText().trim(), (String)HCFormLabelHelper.getDefaultLabelEnd());
        this.addChild((IHCNode)HCFormLabelHelper.getNodeWithState(iHCNodeWithChildren, eLabelType));
    }

    @Override
    @Nonnull
    public String getPlainText() {
        return this.m_sPlainText;
    }

    @Override
    public boolean isTextLabel() {
        return this.m_bTextLabel;
    }

    @Override
    @Nonnull
    public ELabelType getType() {
        return this.m_eType;
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("PlainText", (Object)this.m_sPlainText).append("TextLabel", this.m_bTextLabel).append("Type", (Enum)this.m_eType).getToString();
    }

    @Nonnull
    public static HCFormLabel createOptional(@Nonnull String string) {
        return new HCFormLabel(string, ELabelType.OPTIONAL);
    }

    @Nonnull
    public static HCFormLabel createOptional(@Nonnull IHCElementWithChildren<?> iHCElementWithChildren) {
        return new HCFormLabel((IHCNodeWithChildren<?>)iHCElementWithChildren, ELabelType.OPTIONAL);
    }

    @Nonnull
    public static HCFormLabel createMandatory(@Nonnull String string) {
        return new HCFormLabel(string, ELabelType.MANDATORY);
    }

    @Nonnull
    public static HCFormLabel createMandatory(@Nonnull IHCElementWithChildren<?> iHCElementWithChildren) {
        return new HCFormLabel((IHCNodeWithChildren<?>)iHCElementWithChildren, ELabelType.MANDATORY);
    }

    @Nonnull
    public static HCFormLabel createAlternative(@Nonnull String string) {
        return new HCFormLabel(string, ELabelType.ALTERNATIVE);
    }

    @Nonnull
    public static HCFormLabel createAlternative(@Nonnull IHCElementWithChildren<?> iHCElementWithChildren) {
        return new HCFormLabel((IHCNodeWithChildren<?>)iHCElementWithChildren, ELabelType.ALTERNATIVE);
    }

    @Nonnull
    public static HCFormLabel createPlain(@Nonnull String string) {
        return new HCFormLabel(string, ELabelType.NONE);
    }

    @Nonnull
    public static HCFormLabel createPlain(@Nonnull IHCElementWithChildren<?> iHCElementWithChildren) {
        return new HCFormLabel((IHCNodeWithChildren<?>)iHCElementWithChildren, ELabelType.NONE);
    }

    @Nonnull
    public static HCFormLabel createForCheckBox(@Nonnull String string) {
        return new HCFormLabel((IHCNode)new HCSpan().addChild(string));
    }
}

