/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.html;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.annotation.OutOfBandNode;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.script.HCScriptInlineOnDocumentReady;
import com.helger.html.js.IHasJSCode;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.html.JSHtml;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.uicore.EUICoreCSSPathProvider;
import com.helger.photon.uicore.EUICoreJSPathProvider;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@OutOfBandNode
public class HCCookieConsent
extends HCScriptInlineOnDocumentReady {
    private final ETheme m_eTheme;

    public HCCookieConsent(@Nonnull JSAssocArray jSAssocArray, @Nullable ETheme eTheme) {
        this.setOnDocumentReadyCode((IHasJSCode)JSHtml.window().ref("cookieconsent").invoke("initialise").arg((IJSExpression)jSAssocArray));
        this.m_eTheme = eTheme;
    }

    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        super.onRegisterExternalResources(iHCConversionSettingsToNode, bl);
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EUICoreJSPathProvider.COOKIE_CONSENT);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EUICoreCSSPathProvider.COOKIE_CONSENT_ANIMATION);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EUICoreCSSPathProvider.COOKIE_CONSENT_BASE);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EUICoreCSSPathProvider.COOKIE_CONSENT_LAYOUT);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EUICoreCSSPathProvider.COOKIE_CONSENT_MEDIA);
        if (this.m_eTheme != null) {
            PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)this.m_eTheme.getCSSPathProvider());
        }
    }

    @Nonnull
    public static HCCookieConsent createBottomDefault(@Nonnull String string, @Nullable String string2, @Nonnull String string3, @Nullable String string4) {
        return HCCookieConsent.create(null, false, ETheme.CLASSIC, string, string2, string3, string4, null);
    }

    @Nonnull
    public static HCCookieConsent create(@Nullable EPosition ePosition, boolean bl, @Nullable ETheme eTheme, @Nonnull String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable ISimpleURL iSimpleURL) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"PopupBackgroundColor");
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (ePosition != null) {
            jSAssocArray.add("position", ePosition.getValue());
        }
        if (bl) {
            jSAssocArray.add("static", true);
        }
        if (eTheme != null) {
            jSAssocArray.add("theme", eTheme.getValue());
        }
        JSAssocArray jSAssocArray2 = new JSAssocArray();
        jSAssocArray2.addIf("popup", (IJSExpression)new JSAssocArray().addIfNotNull("background", string).addIfNotNull("text", string2), JSAssocArray::isNotEmpty);
        jSAssocArray2.addIf("button", (IJSExpression)new JSAssocArray().addIfNotNull("background", string3).addIfNotNull("text", string4), JSAssocArray::isNotEmpty);
        jSAssocArray.add("palette", (IJSExpression)jSAssocArray2);
        JSAssocArray jSAssocArray3 = new JSAssocArray();
        if (iSimpleURL != null) {
            jSAssocArray3.add("href", iSimpleURL.getAsString());
        }
        jSAssocArray.addIf("content", (IJSExpression)jSAssocArray3, JSAssocArray::isNotEmpty);
        return new HCCookieConsent(jSAssocArray, eTheme);
    }

    public static enum ETheme {
        CLASSIC("classic", EUICoreCSSPathProvider.COOKIE_CONSENT_THEMES_CLASSIC),
        EDGELESS("edgeless", EUICoreCSSPathProvider.COOKIE_CONSENT_THEMES_EDGELESS);

        private final String m_sValue;
        private final ICSSPathProvider m_aCSS;

        private ETheme(String string2, ICSSPathProvider iCSSPathProvider) {
            this.m_sValue = string2;
            this.m_aCSS = iCSSPathProvider;
        }

        @Nonnull
        @Nonempty
        public String getValue() {
            return this.m_sValue;
        }

        @Nonnull
        public ICSSPathProvider getCSSPathProvider() {
            return this.m_aCSS;
        }
    }

    public static enum EPosition {
        BOTTOM("bottom"),
        TOP("top"),
        BOTTOM_LEFT("bottom-left"),
        BOTTOM_RIGHT("bottom-right");

        private final String m_sValue;

        private EPosition(String string2) {
            this.m_sValue = string2;
        }

        @Nonnull
        @Nonempty
        public String getValue() {
            return this.m_sValue;
        }
    }
}

