/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.datetime;

import jakarta.annotation.Nonnull;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.function.Consumer;

public enum EDateTimeFormatToken {
    ABBR_WEEKDAY_NAME("%a", "EE", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendPattern("EE")),
    FULL_WEEKDAY_NAME("%A", "EEEE", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendPattern("EEEE")),
    ABBR_MONTH_NAME("%b", "MMM", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendPattern("MMM")),
    FULL_MONTH_NAME("%B", "MMMM", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendPattern("MMMM")),
    DAY_OF_MONTH_LZ("%d", "dd", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.DAY_OF_MONTH, 2)),
    DAY_OF_MONTH("%e", "d", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.DAY_OF_MONTH, 1)),
    HOUR23_LZ("%H", "HH", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.HOUR_OF_DAY, 2)),
    HOUR12_LZ("%I", "hh", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.HOUR_OF_AMPM, 2)),
    DAY_OF_YEAR_LZ("%j", "DDD", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.DAY_OF_YEAR, 3)),
    HOUR23("%k", "H", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.HOUR_OF_DAY, 1)),
    HOUR12("%l", "h", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.HOUR_OF_AMPM, 1)),
    MONTH("%m", "M", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.MONTH_OF_YEAR, 1)),
    MONTH_LZ("%m", "MM", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.MONTH_OF_YEAR, 2)),
    MINUTE_LZ("%M", "mm", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.MINUTE_OF_HOUR, 2)),
    CHAR_NEWLINE("%n", "\n", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendLiteral('\n')),
    AMPM_UPPER("%p", "a", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.AMPM_OF_DAY)),
    AMPM_LOWER("%P", "a", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.AMPM_OF_DAY)),
    SECONDS_LZ("%S", "ss", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.SECOND_OF_MINUTE, 2)),
    CHAR_TAB("%t", "\t", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendLiteral('\t')),
    WEEKNUM_LZ("%U", "ww", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.ALIGNED_WEEK_OF_YEAR, 2)),
    YEAR_WITHOUT_CENTURY("%y", "yy", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.YEAR, 2)),
    YEAR_WITH_CENTURY("%Y", "uuuu", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD)),
    CHAR_PERC("%%", "%", dateTimeFormatterBuilder -> dateTimeFormatterBuilder.appendLiteral('%'));

    private final String m_sJSCalendarToken;
    private final String m_sJavaToken;
    private Consumer<DateTimeFormatterBuilder> m_aDTFBC;

    private EDateTimeFormatToken(@Nonnull String string2, String string3, Consumer<DateTimeFormatterBuilder> consumer) {
        this.m_sJSCalendarToken = string2;
        this.m_sJavaToken = string3;
        this.m_aDTFBC = consumer;
    }

    @Nonnull
    public String getJSCalendarToken() {
        return this.m_sJSCalendarToken;
    }

    @Nonnull
    public String getJavaToken() {
        return this.m_sJavaToken;
    }

    public void addToFormatterBuilder(@Nonnull DateTimeFormatterBuilder dateTimeFormatterBuilder) {
        this.m_aDTFBC.accept(dateTimeFormatterBuilder);
    }
}

