/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore.datetime;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.impl.Cache;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.datetime.format.PDTFromString;
import com.helger.photon.uicore.datetime.EDateTimeFormatToken;
import com.helger.photon.uicore.datetime.IDateFormatBuilder;
import com.helger.text.compare.ComparatorHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Comparator;
import java.util.Map;

public final class DateFormatBuilder
implements IDateFormatBuilder {
    private final ICommonsList<Object> m_aList = new CommonsArrayList();
    private static final boolean USE_FORMATTER = true;
    private static final PatternCache CACHE = new PatternCache();

    @Nonnull
    public DateFormatBuilder append(@Nonnull EDateTimeFormatToken eDateTimeFormatToken) {
        ValueEnforcer.notNull((Object)((Object)eDateTimeFormatToken), (String)"Token");
        this.m_aList.add((Object)eDateTimeFormatToken);
        return this;
    }

    @Nonnull
    public DateFormatBuilder append(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Text");
        StringHelper.iterateChars((String)string, c -> {
            if (c == '\n') {
                this.append(EDateTimeFormatToken.CHAR_NEWLINE);
            } else if (c == '\t') {
                this.append(EDateTimeFormatToken.CHAR_TAB);
            } else if (c == '%') {
                this.append(EDateTimeFormatToken.CHAR_PERC);
            } else {
                this.m_aList.add((Object)Character.valueOf(c));
            }
        });
        return this;
    }

    @Override
    @Nonnull
    public ICommonsList<Object> getAllInternalObjects() {
        return (ICommonsList)this.m_aList.getClone();
    }

    @Override
    @Nonnull
    public String getJSCalendarFormatString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object e : this.m_aList) {
            if (e instanceof EDateTimeFormatToken) {
                stringBuilder.append(((EDateTimeFormatToken)((Object)e)).getJSCalendarToken());
                continue;
            }
            stringBuilder.append(((Character)e).charValue());
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public String getJavaFormatString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object e : this.m_aList) {
            if (e instanceof EDateTimeFormatToken) {
                stringBuilder.append(((EDateTimeFormatToken)((Object)e)).getJavaToken());
                continue;
            }
            stringBuilder.append(((Character)e).charValue());
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public DateTimeFormatter getJavaFormatter() {
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        for (Object e : this.m_aList) {
            if (e instanceof EDateTimeFormatToken) {
                ((EDateTimeFormatToken)((Object)e)).addToFormatterBuilder(dateTimeFormatterBuilder);
                continue;
            }
            dateTimeFormatterBuilder.appendLiteral(((Character)e).charValue());
        }
        return dateTimeFormatterBuilder.toFormatter();
    }

    @Override
    @Nonnull
    public LocalDate getDateFormatted(@Nullable String string) {
        return PDTFromString.getLocalDateFromString((String)string, (DateTimeFormatter)this.getJavaFormatter());
    }

    @Override
    @Nonnull
    public LocalTime getTimeFormatted(@Nullable String string) {
        return PDTFromString.getLocalTimeFromString((String)string, (DateTimeFormatter)this.getJavaFormatter());
    }

    @Override
    @Nonnull
    public LocalDateTime getLocalDateTimeFormatted(@Nullable String string) {
        return PDTFromString.getLocalDateTimeFromString((String)string, (DateTimeFormatter)this.getJavaFormatter());
    }

    @Nonnull
    public ZonedDateTime getDateTimeFormatted(@Nullable String string) {
        return PDTFromString.getZonedDateTimeFromString((String)string, (DateTimeFormatter)this.getJavaFormatter());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("list", this.m_aList).getToString();
    }

    @Nonnull
    public static IDateFormatBuilder fromJavaPattern(@Nonnull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"JavaPattern");
        return (IDateFormatBuilder)CACHE.getFromCache(string);
    }

    private static final class PatternCache
    extends Cache<String, DateFormatBuilder> {
        public PatternCache() {
            super(string -> {
                ValueEnforcer.notNull((Object)string, (String)"JavaPattern");
                DateFormatBuilder dateFormatBuilder = new DateFormatBuilder();
                Searcher searcher = new Searcher((String)string);
                while (searcher.hasMore()) {
                    EDateTimeFormatToken eDateTimeFormatToken = searcher.getNextToken();
                    if (eDateTimeFormatToken != null) {
                        dateFormatBuilder.append(eDateTimeFormatToken);
                        continue;
                    }
                    dateFormatBuilder.append(searcher.getNextChar());
                }
                return dateFormatBuilder;
            }, -1, "DateFormatBuilder.PatternCache");
        }
    }

    private static final class Searcher {
        private String m_sRest;
        private final ICommonsMap<String, EDateTimeFormatToken> m_aAllMatching = new CommonsHashMap();
        private final Comparator<String> m_aComp = ComparatorHelper.getComparatorStringLongestFirst();

        public Searcher(@Nonnull String string) {
            this.m_sRest = (String)ValueEnforcer.notNull((Object)string, (String)"Rest");
        }

        public boolean hasMore() {
            return this.m_sRest.length() > 0;
        }

        @Nullable
        public EDateTimeFormatToken getNextToken() {
            this.m_aAllMatching.clear();
            for (EDateTimeFormatToken eDateTimeFormatToken : EDateTimeFormatToken.values()) {
                String string = eDateTimeFormatToken.getJavaToken();
                if (!this.m_sRest.startsWith(string)) continue;
                this.m_aAllMatching.put((Object)string, (Object)eDateTimeFormatToken);
            }
            if (this.m_aAllMatching.isEmpty()) {
                return null;
            }
            Map.Entry entry = this.m_aAllMatching.size() == 1 ? this.m_aAllMatching.getFirstEntry() : this.m_aAllMatching.getSortedByKey(this.m_aComp).getFirstEntry();
            this.m_sRest = this.m_sRest.substring(((String)entry.getKey()).length());
            return (EDateTimeFormatToken)((Object)entry.getValue());
        }

        @Nonnull
        public String getNextChar() {
            String string = this.m_sRest.substring(0, 1);
            this.m_sRest = this.m_sRest.substring(1);
            return string;
        }
    }
}

