/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uicore;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringReplace;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.hierarchy.visit.IHierarchyVisitorCallback;
import com.helger.html.EHTMLVersion;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.grouping.HCP;
import com.helger.html.hc.impl.HCDOMWrapper;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.html.markdown.MarkdownConfiguration;
import com.helger.html.markdown.MarkdownProcessor;
import com.helger.html.parser.XHTMLParser;
import com.helger.photon.uicore.page.external.PageViewExternalHTMLCleanser;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.util.MicroVisitor;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class UITextFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UITextFormatter.class);
    private static final MarkdownProcessor MARKDOWN_PROC = new MarkdownProcessor(MarkdownConfiguration.DEFAULT_SAFE_EXTENSIONS);

    private UITextFormatter() {
    }

    @Nonnull
    public static IHCNode getToStringContent(Object object) {
        String string = String.valueOf(object);
        if (StringHelper.startsWith((CharSequence)string, (char)'[') && StringHelper.endsWith((CharSequence)string, (char)']')) {
            try {
                CommonsArrayList commonsArrayList = new CommonsArrayList();
                String string2 = string.substring(1, string.length() - 1);
                String[] stringArray = RegExHelper.getAllMatchingGroupValues((String)"([\\[]*)([A-Za-z0-9_$]+@0x[0-9a-fA-F]{8})(?:: (.+))?", (String)string2);
                commonsArrayList.add((Object)stringArray[1]);
                if (stringArray[2] != null && (string2 = StringHelper.getConcatenatedOnDemand((String)stringArray[0], (String)stringArray[2]).trim()).length() > 0) {
                    string2 = StringReplace.replaceAll((String)string2, (String)"; ", (CharSequence)";\n");
                    commonsArrayList.addAll((Collection)StringHelper.getExploded((char)'\n', (String)string2));
                }
                HCNodeList hCNodeList = new HCNodeList();
                for (String string3 : commonsArrayList) {
                    hCNodeList.addChild((IHCNode)new HCDiv().addChild(string3));
                }
                return hCNodeList;
            }
            catch (Exception exception) {
                LOGGER.error("Failed to format", (Throwable)exception);
            }
        }
        return new HCTextNode(string);
    }

    @Nonnull
    public static IHCNode markdown(@Nullable String string) {
        try {
            HCNodeList hCNodeList = MARKDOWN_PROC.process(string).getNodeList();
            if (hCNodeList.getChildCount() == 1 && hCNodeList.getChildAtIndex(0) instanceof HCP) {
                return ((HCP)hCNodeList.getChildAtIndex(0)).getAllChildrenAsNodeList();
            }
            return hCNodeList;
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to markdown '" + string + "': " + exception.getMessage());
            return new HCTextNode(string);
        }
    }

    @Nullable
    public static IHCNode markdownOnDemand(@Nullable String string) {
        return StringHelper.isNotEmpty((String)string) ? UITextFormatter.markdown(string) : null;
    }

    @Nonnull
    public static IHCNode unescapeHTML(@Nonnull String string) {
        return UITextFormatter.unescapeHTML(string, (IHierarchyVisitorCallback<? super IMicroNode>)new PageViewExternalHTMLCleanser(HCSettings.getConversionSettings().getHTMLVersion()));
    }

    @Nonnull
    public static IHCNode unescapeHTML(@Nonnull String string, @Nullable IHierarchyVisitorCallback<? super IMicroNode> iHierarchyVisitorCallback) {
        XHTMLParser xHTMLParser = new XHTMLParser(EHTMLVersion.XHTML11);
        IMicroContainer iMicroContainer = xHTMLParser.unescapeXHTMLFragment(string);
        if (iMicroContainer == null) {
            throw new IllegalStateException("Failed to parse HTML code: " + string);
        }
        if (iHierarchyVisitorCallback != null) {
            MicroVisitor.visit((IMicroNode)iMicroContainer, iHierarchyVisitorCallback);
        }
        return new HCDOMWrapper((IMicroNode)iMicroContainer);
    }
}

