/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.user;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.type.ObjectType;
import com.helger.datetime.helper.PDTFactory;
import com.helger.photon.security.object.StubObject;
import com.helger.photon.security.user.IUser;
import com.helger.security.password.hash.PasswordHash;
import com.helger.tenancy.AbstractBusinessObject;
import com.helger.tenancy.IBusinessObject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Map;

@NotThreadSafe
public class User
extends AbstractBusinessObject
implements IUser {
    public static final ObjectType OT = new ObjectType("user");
    private String m_sLoginName;
    private String m_sEmailAddress;
    private PasswordHash m_aPasswordHash;
    private String m_sFirstName;
    private String m_sLastName;
    private String m_sDescription;
    private Locale m_aDesiredLocale;
    private LocalDateTime m_aLastLoginDT;
    private int m_nLoginCount;
    private int m_nConsecutiveFailedLoginCount;
    private boolean m_bDisabled;

    public User(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull PasswordHash passwordHash, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable Locale locale, @Nullable Map<String, String> map, boolean bl) {
        this(StubObject.createForCurrentUser(map), string, string2, passwordHash, string3, string4, string5, locale, null, 0, 0, bl);
    }

    public User(@Nonnull StubObject stubObject, @Nonnull @Nonempty String string, @Nullable String string2, @Nonnull PasswordHash passwordHash, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable Locale locale, @Nullable LocalDateTime localDateTime, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        super((IBusinessObject)stubObject);
        ValueEnforcer.isGE0((int)n, (String)"LoginCount");
        ValueEnforcer.isGE0((int)n2, (String)"ConsecutiveFailedLoginCount");
        this.setLoginName(string);
        this.setEmailAddress(string2);
        this.setPasswordHash(passwordHash);
        this.setFirstName(string3);
        this.setLastName(string4);
        this.setDescription(string5);
        this.setDesiredLocale(locale);
        this.m_aLastLoginDT = localDateTime;
        this.m_nLoginCount = n;
        this.m_nConsecutiveFailedLoginCount = n2;
        this.setDisabled(bl);
    }

    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Override
    public boolean isAdministrator() {
        return "admin".equals(this.getID());
    }

    @Override
    @Nonnull
    @Nonempty
    public String getLoginName() {
        return this.m_sLoginName;
    }

    @Nonnull
    public EChange setLoginName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"loginName");
        if (string.equals(this.m_sLoginName)) {
            return EChange.UNCHANGED;
        }
        this.m_sLoginName = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getEmailAddress() {
        return this.m_sEmailAddress;
    }

    @Nonnull
    public EChange setEmailAddress(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sEmailAddress)) {
            return EChange.UNCHANGED;
        }
        this.m_sEmailAddress = string;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @Nonempty
    public PasswordHash getPasswordHash() {
        return this.m_aPasswordHash;
    }

    @Nonnull
    public EChange setPasswordHash(@Nonnull PasswordHash passwordHash) {
        ValueEnforcer.notNull((Object)passwordHash, (String)"PasswordHash");
        if (passwordHash.equals((Object)this.m_aPasswordHash)) {
            return EChange.UNCHANGED;
        }
        this.m_aPasswordHash = passwordHash;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getFirstName() {
        return this.m_sFirstName;
    }

    @Nonnull
    public EChange setFirstName(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sFirstName)) {
            return EChange.UNCHANGED;
        }
        this.m_sFirstName = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getLastName() {
        return this.m_sLastName;
    }

    @Nonnull
    public EChange setLastName(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sLastName)) {
            return EChange.UNCHANGED;
        }
        this.m_sLastName = string;
        return EChange.CHANGED;
    }

    @Nullable
    public String getDescription() {
        return this.m_sDescription;
    }

    @Nonnull
    public EChange setDescription(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sDescription)) {
            return EChange.UNCHANGED;
        }
        this.m_sDescription = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public Locale getDesiredLocale() {
        return this.m_aDesiredLocale;
    }

    @Nonnull
    public EChange setDesiredLocale(@Nullable Locale locale) {
        if (EqualsHelper.equals((Object)locale, (Object)this.m_aDesiredLocale)) {
            return EChange.UNCHANGED;
        }
        this.m_aDesiredLocale = locale;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public LocalDateTime getLastLoginDateTime() {
        return this.m_aLastLoginDT;
    }

    @Override
    @Nonnegative
    public int getLoginCount() {
        return this.m_nLoginCount;
    }

    @Override
    @Nonnegative
    public int getConsecutiveFailedLoginCount() {
        return this.m_nConsecutiveFailedLoginCount;
    }

    protected void onSuccessfulLogin() {
        this.m_aLastLoginDT = PDTFactory.getCurrentLocalDateTime();
        ++this.m_nLoginCount;
        this.m_nConsecutiveFailedLoginCount = 0;
    }

    protected void onFailedLogin() {
        ++this.m_nConsecutiveFailedLoginCount;
    }

    @Override
    public boolean isDisabled() {
        return this.m_bDisabled;
    }

    @Nonnull
    public EChange setDisabled(boolean bl) {
        if (bl == this.m_bDisabled) {
            return EChange.UNCHANGED;
        }
        this.m_bDisabled = bl;
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("LoginName", (Object)this.m_sLoginName).appendIfNotNull("EmailAddress", (Object)this.m_sEmailAddress).append("PasswordHash", (Object)this.m_aPasswordHash).appendIfNotNull("FirstName", (Object)this.m_sFirstName).appendIfNotNull("LastName", (Object)this.m_sLastName).appendIfNotNull("Description", (Object)this.m_sDescription).appendIfNotNull("DesiredLocale", (Object)this.m_aDesiredLocale).appendIfNotNull("LastLoginDT", (Object)this.m_aLastLoginDT).append("LoginCount", this.m_nLoginCount).append("ConsecutiveFailedLoginCount", this.m_nConsecutiveFailedLoginCount).append("Disabled", this.m_bDisabled).getToString();
    }

    @Nonnull
    public static User createdPredefinedUser(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nonnull PasswordHash passwordHash, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable Locale locale, @Nullable Map<String, String> map, boolean bl) {
        return new User(StubObject.createForCurrentUserAndID(string, map), string2, string3, passwordHash, string4, string5, string6, locale, null, 0, 0, bl);
    }
}

