/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.user;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.id.IHasID;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.string.StringHelper;
import com.helger.base.type.ObjectType;
import com.helger.collection.commons.ICommonsList;
import com.helger.dao.DAOException;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.io.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.security.object.BusinessObjectHelper;
import com.helger.photon.security.token.accesstoken.AccessToken;
import com.helger.photon.security.token.object.AccessTokenList;
import com.helger.photon.security.token.user.IUserToken;
import com.helger.photon.security.token.user.IUserTokenManager;
import com.helger.photon.security.token.user.IUserTokenModificationCallback;
import com.helger.photon.security.token.user.UserToken;
import com.helger.photon.security.user.IUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.util.Map;

public class UserTokenManager
extends AbstractPhotonMapBasedWALDAO<IUserToken, UserToken>
implements IUserTokenManager {
    private final CallbackList<IUserTokenModificationCallback> m_aCallbacks = new CallbackList();

    public UserTokenManager(@Nonnull @Nonempty String string) throws DAOException {
        super(UserToken.class, string);
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IUserTokenModificationCallback> userTokenModificationCallbacks() {
        return this.m_aCallbacks;
    }

    @Override
    @Nonnull
    public UserToken createUserToken(@Nullable String string, @Nullable Map<String, String> map, @Nonnull IUser iUser, @Nullable String string2) {
        UserToken userToken = new UserToken(string, map, iUser, string2);
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem((IHasID)userToken));
        AuditHelper.onAuditCreateSuccess((ObjectType)UserToken.OT, (Object[])new Object[]{userToken.getID(), map, iUser.getID(), string2});
        this.m_aCallbacks.forEach(iUserTokenModificationCallback -> iUserTokenModificationCallback.onUserTokenCreated(userToken));
        return userToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange updateUserToken(@Nullable String string, @Nullable Map<String, String> map, @Nullable String string2) {
        UserToken userToken = (UserToken)this.getOfID(string);
        if (userToken == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)UserToken.OT, (String)"set-all", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.UNCHANGED;
            eChange = eChange.or((IChangeIndicator)userToken.attrs().setAll(map));
            eChange = eChange.or((IChangeIndicator)userToken.setDescription(string2));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow(userToken);
            this.internalUpdateItem((IHasID)userToken);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)UserToken.OT, (String)"set-all", (Object[])new Object[]{string, map, string2});
        this.m_aCallbacks.forEach(iUserTokenModificationCallback -> iUserTokenModificationCallback.onUserTokenUpdated(string));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange deleteUserToken(@Nullable String string) {
        UserToken userToken = (UserToken)this.getOfID(string);
        if (userToken == null) {
            AuditHelper.onAuditDeleteFailure((ObjectType)UserToken.OT, (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow(userToken).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure((ObjectType)UserToken.OT, (Object[])new Object[]{string, "already-deleted"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemDeleted((IHasID)userToken);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)UserToken.OT, (Object[])new Object[]{string});
        this.m_aCallbacks.forEach(iUserTokenModificationCallback -> iUserTokenModificationCallback.onUserTokenDeleted(string));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange createNewAccessToken(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string3, @Nullable String string4) {
        AccessToken accessToken;
        UserToken userToken = (UserToken)this.getOfID(string);
        if (userToken == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)UserToken.OT, (String)"create-new-access-token", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            AccessTokenList accessTokenList = userToken.getAccessTokenList();
            accessTokenList.revokeActiveAccessToken(string2, localDateTime, string3);
            accessToken = accessTokenList.createNewAccessToken(string4);
            BusinessObjectHelper.setLastModificationNow(userToken);
            this.internalUpdateItem((IHasID)userToken);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)UserToken.OT, (String)"create-new-access-token", (Object[])new Object[]{string, string2, localDateTime, string3, string4});
        this.m_aCallbacks.forEach(iUserTokenModificationCallback -> iUserTokenModificationCallback.onUserTokenCreateAccessToken(string, accessToken));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange revokeAccessToken(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string3) {
        UserToken userToken = (UserToken)this.getOfID(string);
        if (userToken == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)UserToken.OT, (String)"revoke-access-token", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (userToken.getAccessTokenList().revokeActiveAccessToken(string2, localDateTime, string3).isUnchanged()) {
                AuditHelper.onAuditModifyFailure((ObjectType)UserToken.OT, (String)"revoke-access-token", (Object[])new Object[]{string, "already-revoked"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(userToken);
            this.internalUpdateItem((IHasID)userToken);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)UserToken.OT, (String)"revoke-access-token", (Object[])new Object[]{string, string2, localDateTime, string3});
        this.m_aCallbacks.forEach(iUserTokenModificationCallback -> iUserTokenModificationCallback.onUserTokenRevokeAccessToken(string));
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUserToken> getAllActiveUserTokens() {
        return this.getAll(iUserToken -> !iUserToken.isDeleted());
    }

    @Override
    @Nullable
    public IUserToken getUserTokenOfID(@Nullable String string) {
        return (IUserToken)this.getOfID(string);
    }

    @Override
    @Nullable
    public IUserToken getUserTokenOfTokenString(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (IUserToken)this.findFirst(iUserToken -> string.equals(iUserToken.getAccessTokenList().getActiveTokenString()));
    }

    @Override
    public boolean isAccessTokenUsed(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return this.containsAny(iUserToken -> iUserToken.getAccessTokenList().findFirstAccessToken(iAccessToken -> iAccessToken.getTokenString().equals(string)) != null);
    }
}

