/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.password.constraint;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.security.password.constraint.EPasswordConstraintText;
import com.helger.photon.security.password.constraint.IPasswordConstraint;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public class PasswordConstraintMustContainLetter
implements IPasswordConstraint {
    private static final String ATTR_MIN_LETTERS = "minletters";
    private final int m_nMinLetters;

    public PasswordConstraintMustContainLetter(@Nonnegative int n) {
        this.m_nMinLetters = ValueEnforcer.isGT0((int)n, (String)"MinLetters");
    }

    @Nonnegative
    public int getMinLetters() {
        return this.m_nMinLetters;
    }

    @Override
    public boolean isPasswordValid(@Nullable String string) {
        int n = 0;
        if (string != null) {
            for (char c : string.toCharArray()) {
                if (!Character.isLetter(c)) continue;
                ++n;
            }
        }
        return n >= this.m_nMinLetters;
    }

    @Override
    @Nullable
    public String getDescription(@Nonnull Locale locale) {
        return EPasswordConstraintText.DESC_MUST_CONTAIN_LETTERS.getDisplayTextWithArgs(locale, new Object[]{this.m_nMinLetters});
    }

    @Override
    public void fillMicroElement(@Nonnull IMicroElement iMicroElement) {
        iMicroElement.setAttribute(ATTR_MIN_LETTERS, this.m_nMinLetters);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordConstraintMustContainLetter passwordConstraintMustContainLetter = (PasswordConstraintMustContainLetter)object;
        return this.m_nMinLetters == passwordConstraintMustContainLetter.m_nMinLetters;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nMinLetters).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("minLetters", this.m_nMinLetters).getToString();
    }
}

