/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.password.constraint;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.photon.security.password.constraint.IPasswordConstraint;
import com.helger.photon.security.password.constraint.IPasswordConstraintList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@NotThreadSafe
public class PasswordConstraintList
implements IPasswordConstraintList {
    private final ICommonsList<IPasswordConstraint> m_aConstraints = new CommonsArrayList();

    public PasswordConstraintList() {
    }

    public PasswordConstraintList(@Nonnull IPasswordConstraintList iPasswordConstraintList) {
        ValueEnforcer.notNull((Object)iPasswordConstraintList, (String)"Other");
        this.m_aConstraints.addAll(iPasswordConstraintList.getAllPasswordConstraints());
    }

    public PasswordConstraintList(IPasswordConstraint ... iPasswordConstraintArray) {
        if (iPasswordConstraintArray != null) {
            for (IPasswordConstraint iPasswordConstraint : iPasswordConstraintArray) {
                this.addConstraint(iPasswordConstraint);
            }
        }
    }

    public PasswordConstraintList(@Nullable Iterable<? extends IPasswordConstraint> iterable) {
        if (iterable != null) {
            for (IPasswordConstraint iPasswordConstraint : iterable) {
                this.addConstraint(iPasswordConstraint);
            }
        }
    }

    @Override
    public boolean hasConstraints() {
        return this.m_aConstraints.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getConstraintCount() {
        return this.m_aConstraints.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IPasswordConstraint> getAllPasswordConstraints() {
        return (ICommonsList)this.m_aConstraints.getClone();
    }

    @Nonnull
    public PasswordConstraintList addConstraint(@Nonnull IPasswordConstraint iPasswordConstraint) {
        ValueEnforcer.notNull((Object)iPasswordConstraint, (String)"PasswordConstraint");
        this.m_aConstraints.add((Object)iPasswordConstraint);
        return this;
    }

    @Nonnull
    public EChange removeConstraint(@Nullable IPasswordConstraint iPasswordConstraint) {
        if (iPasswordConstraint == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aConstraints.removeObject((Object)iPasswordConstraint);
    }

    @Override
    public boolean isPasswordValid(@Nullable String string) {
        for (IPasswordConstraint iPasswordConstraint : this.m_aConstraints) {
            if (iPasswordConstraint.isPasswordValid(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getInvalidPasswordDescriptions(@Nullable String string, @Nonnull Locale locale) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IPasswordConstraint iPasswordConstraint : this.m_aConstraints) {
            if (iPasswordConstraint.isPasswordValid(string)) continue;
            commonsArrayList.add((Object)iPasswordConstraint.getDescription(locale));
        }
        return commonsArrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllPasswordConstraintDescriptions(@Nonnull Locale locale) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IPasswordConstraint iPasswordConstraint : this.m_aConstraints) {
            commonsArrayList.add((Object)iPasswordConstraint.getDescription(locale));
        }
        return commonsArrayList;
    }

    @Nonnull
    public PasswordConstraintList getClone() {
        return new PasswordConstraintList(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordConstraintList passwordConstraintList = (PasswordConstraintList)object;
        return this.m_aConstraints.equals(passwordConstraintList.m_aConstraints);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aConstraints).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("constraints", this.m_aConstraints).getToString();
    }
}

