/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.object.accarea;

import com.helger.annotation.Nonempty;
import com.helger.base.system.SystemHelper;
import com.helger.masterdata.address.IPostalAddress;
import com.helger.masterdata.address.PostalAddress;
import com.helger.masterdata.currency.ECurrency;
import com.helger.photon.security.object.AbstractBusinessObjectMicroTypeConverter;
import com.helger.photon.security.object.accarea.AccountingArea;
import com.helger.tenancy.IBusinessObject;
import com.helger.tenancy.tenant.ITenant;
import com.helger.tenancy.tenant.ITenantResolver;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public final class AccountingAreaMicroTypeConverter
extends AbstractBusinessObjectMicroTypeConverter<AccountingArea> {
    private static final IMicroQName ATTR_TENANT_ID = new MicroQName("clientid");
    private static final IMicroQName ATTR_DISPLAYNAME = new MicroQName("displayname");
    private static final IMicroQName ATTR_COMPANY_TYPE = new MicroQName("companytype");
    private static final IMicroQName ATTR_COMPANY_VATIN = new MicroQName("companyvatin");
    private static final IMicroQName ATTR_COMPANY_NUMBER = new MicroQName("companynumber");
    private static final IMicroQName ATTR_CUSTOMER_NUMBER = new MicroQName("customernumber");
    private static final String ELEMENT_ADDRESS = "address";
    private static final IMicroQName ATTR_TELEPHONE = new MicroQName("telephone");
    private static final IMicroQName ATTR_FAX = new MicroQName("fax");
    private static final IMicroQName ATTR_EMAILADDRESS = new MicroQName("emailaddress");
    private static final IMicroQName ATTR_WEBSITE = new MicroQName("website");
    private static final IMicroQName ATTR_DEFAULTCURRENCY = new MicroQName("defaultcurrency");
    private static final IMicroQName ATTR_OFFICE_LOCATION = new MicroQName("officelocation");
    private static final IMicroQName ATTR_COMMERCIAL_REGISTRATION_NUMBER = new MicroQName("commregno");
    private static final IMicroQName ATTR_COMMERCIAL_COURT = new MicroQName("commcourt");
    private final ITenantResolver m_aTenantResolver;

    public AccountingAreaMicroTypeConverter(@Nonnull ITenantResolver iTenantResolver) {
        this.m_aTenantResolver = iTenantResolver;
    }

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull AccountingArea accountingArea, @Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_TENANT_ID, accountingArea.getTenantID());
        AccountingAreaMicroTypeConverter.setObjectFields((IBusinessObject)accountingArea, (IMicroElement)microElement);
        microElement.setAttribute(ATTR_DISPLAYNAME, accountingArea.getDisplayName());
        microElement.setAttribute(ATTR_COMPANY_TYPE, accountingArea.getCompanyType());
        microElement.setAttribute(ATTR_COMPANY_VATIN, accountingArea.getCompanyVATIN());
        microElement.setAttribute(ATTR_COMPANY_NUMBER, accountingArea.getCompanyNumber());
        microElement.setAttribute(ATTR_CUSTOMER_NUMBER, accountingArea.getCustomerNumber());
        microElement.addChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)accountingArea.getAddress(), (String)string, (String)ELEMENT_ADDRESS));
        microElement.setAttribute(ATTR_TELEPHONE, accountingArea.getTelephone());
        microElement.setAttribute(ATTR_FAX, accountingArea.getFax());
        microElement.setAttribute(ATTR_EMAILADDRESS, accountingArea.getEmailAddress());
        microElement.setAttribute(ATTR_WEBSITE, accountingArea.getWebSite());
        microElement.setAttribute(ATTR_DEFAULTCURRENCY, accountingArea.getDefaultCurrencyID());
        microElement.setAttribute(ATTR_OFFICE_LOCATION, accountingArea.getOfficeLocation());
        microElement.setAttribute(ATTR_COMMERCIAL_REGISTRATION_NUMBER, accountingArea.getCommercialRegistrationNumber());
        microElement.setAttribute(ATTR_COMMERCIAL_COURT, accountingArea.getCommercialCourt());
        return microElement;
    }

    @Nonnull
    public AccountingArea convertToNative(@Nonnull IMicroElement iMicroElement) {
        Locale locale = SystemHelper.getSystemLocale();
        String string = iMicroElement.getAttributeValue(ATTR_TENANT_ID);
        ITenant iTenant = this.m_aTenantResolver.getTenantOfID(string);
        if (iTenant == null) {
            throw new IllegalStateException("Failed to resolve tenant ID '" + string + "'");
        }
        String string2 = iMicroElement.getAttributeValue(ATTR_DISPLAYNAME);
        String string3 = iMicroElement.getAttributeValue(ATTR_COMPANY_TYPE);
        String string4 = iMicroElement.getAttributeValue(ATTR_COMPANY_VATIN);
        String string5 = iMicroElement.getAttributeValue(ATTR_COMPANY_NUMBER);
        String string6 = iMicroElement.getAttributeValue(ATTR_CUSTOMER_NUMBER);
        PostalAddress postalAddress = (PostalAddress)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement.getFirstChildElement(ELEMENT_ADDRESS), PostalAddress.class);
        String string7 = iMicroElement.getAttributeValue(ATTR_TELEPHONE);
        String string8 = iMicroElement.getAttributeValue(ATTR_FAX);
        String string9 = iMicroElement.getAttributeValue(ATTR_EMAILADDRESS);
        String string10 = iMicroElement.getAttributeValue(ATTR_WEBSITE);
        String string11 = iMicroElement.getAttributeValue(ATTR_DEFAULTCURRENCY);
        ECurrency eCurrency = ECurrency.getFromIDOrNull((String)string11);
        String string12 = iMicroElement.getAttributeValue(ATTR_OFFICE_LOCATION);
        String string13 = iMicroElement.getAttributeValue(ATTR_COMMERCIAL_REGISTRATION_NUMBER);
        String string14 = iMicroElement.getAttributeValue(ATTR_COMMERCIAL_COURT);
        return new AccountingArea(iTenant, AccountingAreaMicroTypeConverter.getStubObject(iMicroElement), string2, string3, string4, string5, string6, (IPostalAddress)postalAddress, string7, string8, string9, string10, eCurrency, string12, string13, string14, locale);
    }
}

