/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.object.accarea;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.tenancy.AbstractBusinessObject;
import com.helger.tenancy.IBusinessObject;
import com.helger.tenancy.accarea.IAccountingArea;
import com.helger.tenancy.accarea.IAccountingAreaObject;
import com.helger.tenancy.tenant.ITenant;
import com.helger.tenancy.tenant.ITenantObject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.util.Map;

@Immutable
public abstract class AbstractAccountingAreaOptionalObject
extends AbstractBusinessObject
implements IAccountingAreaObject {
    private final ITenant m_aTenant;
    private final IAccountingArea m_aAccountingArea;
    private int m_nHashCode = 0;

    protected AbstractAccountingAreaOptionalObject(@Nonnull IAccountingAreaObject iAccountingAreaObject) {
        super((IBusinessObject)iAccountingAreaObject);
        this.m_aTenant = iAccountingAreaObject.getTenant();
        this.m_aAccountingArea = iAccountingAreaObject.getAccountingArea();
    }

    public AbstractAccountingAreaOptionalObject(@Nonnull IAccountingArea iAccountingArea, @Nonnull IBusinessObject iBusinessObject) {
        this(iAccountingArea.getTenant(), iAccountingArea, iBusinessObject);
    }

    public AbstractAccountingAreaOptionalObject(@Nonnull ITenant iTenant, @Nullable IAccountingArea iAccountingArea, @Nonnull IBusinessObject iBusinessObject) {
        super(iBusinessObject);
        ValueEnforcer.notNull((Object)iTenant, (String)"Tenant");
        if (iAccountingArea != null && !iAccountingArea.hasSameTenant(iTenant)) {
            throw new IllegalArgumentException("The passed accounting area '" + (String)iAccountingArea.getID() + "' does not belong to the passed tenant '" + (String)iTenant.getID() + "'!");
        }
        this.m_aTenant = iTenant;
        this.m_aAccountingArea = iAccountingArea;
    }

    public AbstractAccountingAreaOptionalObject(@Nonnull ITenant iTenant, @Nullable IAccountingArea iAccountingArea, @Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nullable String string2, @Nullable LocalDateTime localDateTime2, @Nullable String string3, @Nullable LocalDateTime localDateTime3, @Nullable String string4) {
        super(string, localDateTime, string2, localDateTime2, string3, localDateTime3, string4, (Map)null);
        ValueEnforcer.notNull((Object)iTenant, (String)"Tenant");
        if (iAccountingArea != null && !iAccountingArea.hasSameTenant(iTenant)) {
            throw new IllegalArgumentException("The passed accounting area '" + (String)iAccountingArea.getID() + "' does not belong to the passed tenant '" + (String)iTenant.getID() + "'!");
        }
        this.m_aTenant = iTenant;
        this.m_aAccountingArea = iAccountingArea;
    }

    @Nonnull
    public final ITenant getTenant() {
        return this.m_aTenant;
    }

    @Nullable
    public final String getAccountingAreaID() {
        return this.m_aAccountingArea == null ? null : (String)this.m_aAccountingArea.getID();
    }

    @Nullable
    public final IAccountingArea getAccountingArea() {
        return this.m_aAccountingArea;
    }

    public final boolean hasSameTenantAndAccountingAreaID(@Nullable IAccountingArea iAccountingArea) {
        return iAccountingArea != null && this.hasSameTenantID((ITenantObject)iAccountingArea) && (this.m_aAccountingArea == null || ((String)this.m_aAccountingArea.getID()).equals(iAccountingArea.getID()));
    }

    public final boolean hasSameTenantAndAccountingAreaID(@Nullable IAccountingAreaObject iAccountingAreaObject) {
        return iAccountingAreaObject != null && this.hasSameTenantID((ITenantObject)iAccountingAreaObject) && (this.m_aAccountingArea == null || ((String)this.m_aAccountingArea.getID()).equals(iAccountingAreaObject.getAccountingAreaID()));
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !((Object)((Object)this)).getClass().equals(object.getClass())) {
            return false;
        }
        AbstractAccountingAreaOptionalObject abstractAccountingAreaOptionalObject = (AbstractAccountingAreaOptionalObject)((Object)object);
        return this.m_aTenant.equals((Object)abstractAccountingAreaOptionalObject.m_aTenant) && EqualsHelper.equals((Object)this.m_aAccountingArea, (Object)abstractAccountingAreaOptionalObject.m_aAccountingArea) && this.getID().equals(abstractAccountingAreaOptionalObject.getID());
    }

    public final int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator((Object)this).append((Object)this.m_aTenant).append((Object)this.m_aAccountingArea).append((Object)this.getID()).getHashCode();
        }
        return n;
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Tenant", (Object)this.m_aTenant).append("AccoutingArea", (Object)this.m_aAccountingArea).getToString();
    }
}

