/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.login;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.io.file.FileOperationManager;
import com.helger.io.file.FilenameHelper;
import com.helger.photon.io.WebFileIO;
import com.helger.photon.security.login.LoggedInUserManager;
import jakarta.annotation.Nonnull;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class LoggedInUserStorage {
    public static final String BASE_DIRECTORY = "userdata/";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggedInUserStorage.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static String s_sBaseDirectory = "userdata/";

    private LoggedInUserStorage() {
    }

    @Nonnull
    public static String getBaseDirectory() {
        return (String)RW_LOCK.readLockedGet(() -> s_sBaseDirectory);
    }

    public static void setBaseDirectory(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"BaseDirectory");
        RW_LOCK.writeLocked(() -> {
            s_sBaseDirectory = string;
        });
    }

    @Nonnull
    public static File getUserdataDirectory() {
        String string = LoggedInUserManager.getInstance().getCurrentUserID();
        return LoggedInUserStorage.getUserdataDirectory(string);
    }

    @Nonnull
    public static File getUserdataDirectory(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"UserID");
        String string2 = FilenameHelper.getAsSecureValidASCIIFilename((String)string);
        if (StringHelper.isEmpty((String)string2)) {
            throw new IllegalStateException("Passed user ID '" + string + "' is an empty filename!");
        }
        if (!string2.equals(string)) {
            LOGGER.warn("User ID '" + string + "' was modified to '" + string2 + "' to be used as a file system name!");
        }
        File file = WebFileIO.getDataIO().getFile(LoggedInUserStorage.getBaseDirectory() + string2);
        FileOperationManager.INSTANCE.createDirRecursiveIfNotExisting(file);
        return file;
    }
}

