/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.login;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.callback.CallbackList;
import com.helger.base.callback.ICallback;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.security.lock.ObjectLockManager;
import com.helger.photon.security.login.ELoginResult;
import com.helger.photon.security.login.IUserLoginCallback;
import com.helger.photon.security.login.IUserLogoutCallback;
import com.helger.photon.security.login.LoginInfo;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.password.GlobalPasswordSettings;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.IUserManager;
import com.helger.photon.security.util.SecurityHelper;
import com.helger.scope.IScope;
import com.helger.scope.ISessionScope;
import com.helger.scope.mgr.ScopeManager;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import com.helger.security.authentication.subject.user.ICurrentUserIDProvider;
import com.helger.web.scope.ISessionWebScope;
import com.helger.web.scope.session.ISessionWebScopeActivationHandler;
import com.helger.web.scope.singleton.AbstractSessionWebSingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class LoggedInUserManager
extends AbstractGlobalSingleton
implements ICurrentUserIDProvider {
    public static final boolean DEFAULT_LOGOUT_ALREADY_LOGGED_IN_USER = false;
    public static final boolean DEFAULT_ANONYMOUS_LOGGING = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggedInUserManager.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, LoginInfo> m_aLoggedInUsers = new CommonsHashMap();
    private final CallbackList<IUserLoginCallback> m_aUserLoginCallbacks = new CallbackList();
    private final CallbackList<IUserLogoutCallback> m_aUserLogoutCallbacks = new CallbackList();
    private boolean m_bLogoutAlreadyLoggedInUser = false;
    private boolean m_bAnonymousLogging = false;

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public LoggedInUserManager() {
        this.m_aUserLogoutCallbacks.add((ICallback)new InternalUserLogoutCallbackUnlockAllObjects());
    }

    @Nonnull
    public static LoggedInUserManager getInstance() {
        return (LoggedInUserManager)LoggedInUserManager.getGlobalSingleton(LoggedInUserManager.class);
    }

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IUserLoginCallback> userLoginCallbacks() {
        return this.m_aUserLoginCallbacks;
    }

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IUserLogoutCallback> userLogoutCallbacks() {
        return this.m_aUserLogoutCallbacks;
    }

    public boolean isLogoutAlreadyLoggedInUser() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bLogoutAlreadyLoggedInUser);
    }

    public void setLogoutAlreadyLoggedInUser(boolean bl) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_bLogoutAlreadyLoggedInUser = bl;
        });
    }

    public boolean isAnonymousLogging() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bAnonymousLogging);
    }

    public void setAnonymousLogging(boolean bl) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_bAnonymousLogging = bl;
        });
    }

    @Nonnull
    private String _getUserIDLogText(@Nullable String string) {
        if (this.isAnonymousLogging()) {
            return "a user";
        }
        return "user '" + string + "'";
    }

    @Nonnull
    private ELoginResult _onLoginError(@Nonnull @Nonempty String string, @Nonnull ELoginResult eLoginResult) {
        this.m_aUserLoginCallbacks.forEach(iUserLoginCallback -> iUserLoginCallback.onUserLoginError(string, eLoginResult));
        return eLoginResult;
    }

    void internalSessionActivateUser(@Nonnull IUser iUser, @Nonnull ISessionScope iSessionScope) {
        ValueEnforcer.notNull((Object)iUser, (String)"User");
        ValueEnforcer.notNull((Object)iSessionScope, (String)"SessionScope");
        LoginInfo loginInfo = new LoginInfo(iUser, iSessionScope);
        this.m_aRWLock.writeLocked(() -> this.m_aLoggedInUsers.put((Object)((String)iUser.getID()), (Object)loginInfo));
    }

    @Nonnull
    public ELoginResult loginUser(@Nullable String string, @Nullable String string2) {
        return this.loginUser(string, string2, (Iterable<String>)null);
    }

    @Nonnull
    public ELoginResult loginUser(@Nullable String string, @Nullable String string2, @Nullable Iterable<String> iterable) {
        IUser iUser = PhotonSecurityManager.getUserMgr().getUserOfLoginName(string);
        if (iUser == null) {
            AuditHelper.onAuditExecuteFailure((String)"login", (Object[])new Object[]{string, "no-such-loginname"});
            return ELoginResult.USER_NOT_EXISTING;
        }
        return this.loginUser(iUser, string2, iterable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ELoginResult loginUser(@Nullable IUser iUser, @Nullable String string, @Nullable Iterable<String> iterable) {
        LoginInfo loginInfo;
        String string2;
        if (iUser == null) {
            return ELoginResult.USER_NOT_EXISTING;
        }
        String string3 = (String)iUser.getID();
        if (iUser.isDeleted()) {
            AuditHelper.onAuditExecuteFailure((String)"login", (Object[])new Object[]{string3, "user-is-deleted"});
            return this._onLoginError(string3, ELoginResult.USER_IS_DELETED);
        }
        if (iUser.isDisabled()) {
            AuditHelper.onAuditExecuteFailure((String)"login", (Object[])new Object[]{string3, "user-is-disabled"});
            return this._onLoginError(string3, ELoginResult.USER_IS_DISABLED);
        }
        IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
        if (!iUserManager.areUserIDAndPasswordValid(string3, string)) {
            AuditHelper.onAuditExecuteFailure((String)"login", (Object[])new Object[]{string3, "invalid-password"});
            return this._onLoginError(string3, ELoginResult.INVALID_PASSWORD);
        }
        assert (string != null);
        if (!SecurityHelper.hasUserAllRoles(string3, iterable)) {
            AuditHelper.onAuditExecuteFailure((String)"login", (Object[])new Object[]{string3, "user-is-missing-required-roles", iterable});
            return this._onLoginError(string3, ELoginResult.USER_IS_MISSING_ROLE);
        }
        String string4 = iUser.getPasswordHash().getAlgorithmName();
        if (!string4.equals(string2 = GlobalPasswordSettings.getPasswordHashCreatorManager().getDefaultPasswordHashCreatorAlgorithmName())) {
            iUserManager.setUserPassword(string3, string);
            LOGGER.info("Updated password hash of " + this._getUserIDLogText(string3) + " from algorithm '" + string4 + "' to '" + string2 + "'");
        }
        boolean bl = false;
        this.m_aRWLock.writeLock().lock();
        try {
            InternalSessionUserHolder internalSessionUserHolder;
            if (this.m_aLoggedInUsers.containsKey((Object)string3)) {
                if (this.isLogoutAlreadyLoggedInUser()) {
                    this.logoutUser(string3);
                    if (this.m_aLoggedInUsers.containsKey((Object)string3)) {
                        throw new IllegalStateException("Failed to logout '" + string3 + "'");
                    }
                    AuditHelper.onAuditExecuteSuccess((String)"logout-in-login", (Object[])new Object[]{string3});
                    bl = true;
                } else {
                    AuditHelper.onAuditExecuteFailure((String)"login", (Object[])new Object[]{string3, "user-already-logged-in"});
                    ELoginResult eLoginResult = this._onLoginError(string3, ELoginResult.USER_ALREADY_LOGGED_IN);
                    return eLoginResult;
                }
            }
            if ((internalSessionUserHolder = InternalSessionUserHolder._getInstance())._hasUser()) {
                LOGGER.warn("The session user holder already has the user ID '" + internalSessionUserHolder._getUserID() + "' so the new ID '" + string3 + "' will not be set!");
                AuditHelper.onAuditExecuteFailure((String)"login", (Object[])new Object[]{string3, "session-already-has-user"});
                ELoginResult eLoginResult = this._onLoginError(string3, ELoginResult.SESSION_ALREADY_HAS_USER);
                return eLoginResult;
            }
            loginInfo = new LoginInfo(iUser, ScopeManager.getSessionScope());
            this.m_aLoggedInUsers.put((Object)string3, (Object)loginInfo);
            internalSessionUserHolder._setUser(this, iUser);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        LOGGER.info("Logged in " + this._getUserIDLogText(string3) + (String)(this.isAnonymousLogging() ? "" : " with login name '" + iUser.getLoginName() + "'"));
        AuditHelper.onAuditExecuteSuccess((String)"login-user", (Object[])new Object[]{string3, iUser.getLoginName()});
        this.m_aUserLoginCallbacks.forEach(iUserLoginCallback -> iUserLoginCallback.onUserLogin(loginInfo));
        return bl ? ELoginResult.SUCCESS_WITH_LOGOUT : ELoginResult.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange logoutUser(@Nullable String string) {
        LoginInfo loginInfo;
        this.m_aRWLock.writeLock().lock();
        try {
            loginInfo = (LoginInfo)this.m_aLoggedInUsers.remove((Object)string);
            if (loginInfo == null) {
                AuditHelper.onAuditExecuteSuccess((String)"logout", (Object[])new Object[]{string, "user-not-logged-in"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            InternalSessionUserHolder internalSessionUserHolder = InternalSessionUserHolder._getInstanceIfInstantiatedInScope(loginInfo.getSessionScope());
            if (internalSessionUserHolder != null) {
                internalSessionUserHolder._reset();
            }
            loginInfo.setLogoutDTNow();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        LOGGER.info("Logged out " + this._getUserIDLogText(string) + " after " + Duration.between(loginInfo.getLoginDT(), loginInfo.getLogoutDT()).toString());
        AuditHelper.onAuditExecuteSuccess((String)"logout", (Object[])new Object[]{string});
        this.m_aUserLogoutCallbacks.forEach(iUserLogoutCallback -> iUserLogoutCallback.onUserLogout(loginInfo));
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange logoutCurrentUser() {
        return this.logoutUser(this.getCurrentUserID());
    }

    public boolean isUserLoggedIn(@Nullable String string) {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aLoggedInUsers.containsKey((Object)string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllLoggedInUserIDs() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aLoggedInUsers.copyOfKeySet());
    }

    @Nullable
    public LoginInfo getLoginInfo(@Nullable String string) {
        return (LoginInfo)this.m_aRWLock.readLockedGet(() -> (LoginInfo)this.m_aLoggedInUsers.get((Object)string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsCollection<LoginInfo> getAllLoginInfos() {
        return (ICommonsCollection)this.m_aRWLock.readLockedGet(() -> this.m_aLoggedInUsers.copyOfValues());
    }

    @Nonnegative
    public int getLoggedInUserCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aLoggedInUsers.size());
    }

    @Nullable
    public String getCurrentUserID() {
        InternalSessionUserHolder internalSessionUserHolder = InternalSessionUserHolder._getInstanceIfInstantiated();
        return internalSessionUserHolder == null ? null : internalSessionUserHolder.m_sUserID;
    }

    public boolean isUserLoggedInInCurrentSession() {
        return this.getCurrentUserID() != null;
    }

    public boolean isNoUserLoggedInInCurrentSession() {
        return this.getCurrentUserID() == null;
    }

    @Nullable
    public IUser getCurrentUser() {
        InternalSessionUserHolder internalSessionUserHolder = InternalSessionUserHolder._getInstanceIfInstantiated();
        return internalSessionUserHolder == null ? null : internalSessionUserHolder.m_aUser;
    }

    public boolean isCurrentUserAdministrator() {
        IUser iUser = this.getCurrentUser();
        return iUser != null && iUser.isAdministrator();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("loggedInUsers", this.m_aLoggedInUsers).append("userLoginCallbacks", this.m_aUserLoginCallbacks).append("userLogoutCallbacks", this.m_aUserLogoutCallbacks).append("logoutAlreadyLoggedInUser", this.m_bLogoutAlreadyLoggedInUser).getToString();
    }

    static final class InternalUserLogoutCallbackUnlockAllObjects
    implements IUserLogoutCallback {
        InternalUserLogoutCallbackUnlockAllObjects() {
        }

        @Override
        public void onUserLogout(@Nonnull LoginInfo loginInfo) {
            ObjectLockManager objectLockManager = ObjectLockManager.getInstanceIfInstantiated();
            if (objectLockManager != null) {
                objectLockManager.getDefaultLockMgr().unlockAllObjectsOfUser(loginInfo.getUserID());
            }
        }
    }

    public static final class InternalSessionUserHolder
    extends AbstractSessionWebSingleton
    implements ISessionWebScopeActivationHandler {
        private IUser m_aUser;
        private String m_sUserID;
        private LoggedInUserManager m_aOwningMgr;

        @Deprecated(forRemoval=false)
        @UsedViaReflection
        public InternalSessionUserHolder() {
        }

        @Nonnull
        private static InternalSessionUserHolder _getInstance() {
            return (InternalSessionUserHolder)InternalSessionUserHolder.getSessionSingleton(InternalSessionUserHolder.class);
        }

        @Nullable
        private static InternalSessionUserHolder _getInstanceIfInstantiated() {
            return (InternalSessionUserHolder)InternalSessionUserHolder.getSessionSingletonIfInstantiated(InternalSessionUserHolder.class);
        }

        @Nullable
        private static InternalSessionUserHolder _getInstanceIfInstantiatedInScope(@Nullable ISessionScope iSessionScope) {
            return (InternalSessionUserHolder)InternalSessionUserHolder.getSingletonIfInstantiated((IScope)iSessionScope, InternalSessionUserHolder.class);
        }

        private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.m_sUserID != null) {
                this.m_aUser = PhotonSecurityManager.getUserMgr().getUserOfID(this.m_sUserID);
                if (this.m_aUser == null) {
                    throw new IllegalStateException("Failed to resolve user with ID '" + this.m_sUserID + "'");
                }
            }
            this.m_aOwningMgr = LoggedInUserManager.getInstance();
        }

        public void onSessionDidActivate(@Nonnull ISessionWebScope iSessionWebScope) {
            this.m_aOwningMgr.internalSessionActivateUser(this.m_aUser, (ISessionScope)iSessionWebScope);
        }

        private boolean _hasUser() {
            return this.m_aUser != null;
        }

        @Nullable
        private String _getUserID() {
            return this.m_sUserID;
        }

        private void _setUser(@Nonnull LoggedInUserManager loggedInUserManager, @Nonnull IUser iUser) {
            ValueEnforcer.notNull((Object)((Object)loggedInUserManager), (String)"OwningMgr");
            ValueEnforcer.notNull((Object)iUser, (String)"User");
            if (this.m_aUser != null) {
                throw new IllegalStateException("Session already has a user!");
            }
            this.m_aOwningMgr = loggedInUserManager;
            this.m_aUser = iUser;
            this.m_sUserID = (String)iUser.getID();
        }

        private void _reset() {
            this.m_aUser = null;
            this.m_sUserID = null;
            this.m_aOwningMgr = null;
        }

        protected void onDestroy(@Nonnull IScope iScope) {
            LoggedInUserManager loggedInUserManager = this.m_aOwningMgr;
            String string = this.m_sUserID;
            this._reset();
            if (loggedInUserManager != null) {
                loggedInUserManager.logoutUser(string);
            }
        }

        public String toString() {
            return ToStringGenerator.getDerived((String)super.toString()).append("userID", (Object)this.m_sUserID).getToString();
        }
    }
}

