/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.lock;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.photon.security.lock.ELocked;
import com.helger.photon.security.lock.ILockedIndicator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;

@Immutable
public final class LockResult<IDTYPE>
implements ILockedIndicator {
    private final IDTYPE m_aObjID;
    private final ELocked m_eLocked;
    private final boolean m_bIsNewLock;
    private final ICommonsList<IDTYPE> m_aUnlockedObjects;

    public LockResult(@Nonnull IDTYPE IDTYPE, @Nonnull ELocked eLocked, boolean bl, @Nullable List<IDTYPE> list) {
        this.m_aObjID = ValueEnforcer.notNull(IDTYPE, (String)"ObjectID");
        this.m_eLocked = (ELocked)ValueEnforcer.notNull((Object)eLocked, (String)"Locked");
        this.m_bIsNewLock = bl;
        this.m_aUnlockedObjects = new CommonsArrayList(list);
    }

    @Nonnull
    public IDTYPE getLockedObjectID() {
        return this.m_aObjID;
    }

    @Override
    public boolean isLocked() {
        return this.m_eLocked.isLocked();
    }

    @Override
    public boolean isNotLocked() {
        return this.m_eLocked.isNotLocked();
    }

    public boolean isNewLock() {
        return this.m_bIsNewLock;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IDTYPE> getUnlockedObjects() {
        return (ICommonsList)this.m_aUnlockedObjects.getClone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LockResult lockResult = (LockResult)object;
        return this.m_aObjID.equals(lockResult.m_aObjID) && this.m_eLocked.equals(lockResult.m_eLocked) && this.m_bIsNewLock == lockResult.m_bIsNewLock && this.m_aUnlockedObjects.equals(lockResult.m_aUnlockedObjects);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aObjID).append((Object)this.m_eLocked).append(this.m_bIsNewLock).append(this.m_aUnlockedObjects).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("objID", this.m_aObjID).append("locked", (Enum)this.m_eLocked).append("isNewLock", this.m_bIsNewLock).appendIf("unlockedObjects", this.m_aUnlockedObjects, CollectionHelper::isNotEmpty).getToString();
    }

    @Nonnull
    public static <IDTYPE> LockResult<IDTYPE> createFailure(@Nonnull IDTYPE IDTYPE) {
        return new LockResult<IDTYPE>(IDTYPE, ELocked.NOT_LOCKED, false, null);
    }
}

