/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.auth;

import com.helger.annotation.style.IsSPIImplementation;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.token.credentials.ITokenCredentials;
import com.helger.photon.security.token.user.IUserToken;
import com.helger.photon.security.token.user.IUserTokenManager;
import com.helger.security.authentication.credentials.IAuthCredentialToSubjectResolverSPI;
import com.helger.security.authentication.credentials.IAuthCredentials;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@IsSPIImplementation
public class UserTokenAuthCredentialToSubjectResolverSPI
implements IAuthCredentialToSubjectResolverSPI {
    public boolean supportsCredentials(@Nonnull IAuthCredentials iAuthCredentials) {
        return iAuthCredentials instanceof ITokenCredentials;
    }

    @Nullable
    public IUserToken getSubjectFromCredentials(@Nonnull IAuthCredentials iAuthCredentials) {
        ITokenCredentials iTokenCredentials = (ITokenCredentials)iAuthCredentials;
        IUserTokenManager iUserTokenManager = PhotonSecurityManager.getUserTokenMgr();
        return iUserTokenManager.getUserTokenOfTokenString(iTokenCredentials.getTokenString());
    }
}

