/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.auth;

import com.helger.annotation.style.IsSPIImplementation;
import com.helger.photon.security.login.ELoginResult;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.photon.security.user.credentials.IUserPasswordCredentials;
import com.helger.security.authentication.credentials.IAuthCredentialValidatorSPI;
import com.helger.security.authentication.credentials.IAuthCredentials;
import jakarta.annotation.Nonnull;

@IsSPIImplementation
public final class UserAuthCredentialValidatorSPI
implements IAuthCredentialValidatorSPI {
    public boolean supportsCredentials(@Nonnull IAuthCredentials iAuthCredentials) {
        return iAuthCredentials instanceof IUserPasswordCredentials;
    }

    @Nonnull
    public ELoginResult validateCredentials(@Nonnull IAuthCredentials iAuthCredentials) {
        IUserPasswordCredentials iUserPasswordCredentials = (IUserPasswordCredentials)iAuthCredentials;
        return LoggedInUserManager.getInstance().loginUser(iUserPasswordCredentials.getUser(), iUserPasswordCredentials.getPassword(), (Iterable<String>)iUserPasswordCredentials.getAllRequiredRoles());
    }
}

