/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode.type;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.js.JSMarshaller;
import com.helger.html.jscode.AbstractJSType;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSPrinter;
import com.helger.html.jscode.JSRef;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@CodingStyleguideUnaware
public abstract class JSPrimitiveType
extends AbstractJSType {
    private final String m_sName;
    private final JSRef m_aGlobal;

    protected JSPrimitiveType(@Nonnull @Nonempty String string) {
        if (!JSMarshaller.isJSIdentifier((String)string)) {
            throw new IllegalArgumentException("The name '" + string + "' is not a legal JS identifier!");
        }
        this.m_sName = string;
        this.m_aGlobal = JSExpr.ref(string);
    }

    @Override
    @Nonnull
    @Nonempty
    public final String name() {
        return this.m_sName;
    }

    @Nonnull
    public final JSRef global() {
        return this.m_aGlobal;
    }

    @Override
    public final void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain(this.m_sName);
    }

    @Nonnull
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSPrimitiveType jSPrimitiveType = (JSPrimitiveType)object;
        return this.m_sName.equals(jSPrimitiveType.m_sName);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_sName).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("name", (Object)this.m_sName).getToString();
    }
}

