/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSCase;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSOp;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSSwitch
extends AbstractJSStatement {
    private final IJSExpression m_aTest;
    private final ICommonsList<JSCase> m_aCases = new CommonsArrayList();
    private JSCase m_aDefaultCase;

    public JSSwitch(@Nonnull IJSExpression iJSExpression) {
        this.m_aTest = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Test");
    }

    @Nonnull
    public IJSExpression test() {
        return this.m_aTest;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<JSCase> cases() {
        return (ICommonsList)this.m_aCases.getClone();
    }

    @Nonnull
    @CodingStyleguideUnaware
    public JSCase _case(@Nonnull IJSExpression iJSExpression) {
        JSCase jSCase = new JSCase(iJSExpression);
        this.m_aCases.add((Object)jSCase);
        return jSCase;
    }

    @Nonnull
    @CodingStyleguideUnaware
    public JSCase _case(int n) {
        return this._case(JSExpr.lit(n));
    }

    @Nonnull
    @CodingStyleguideUnaware
    public JSCase _case(long l) {
        return this._case(JSExpr.lit(l));
    }

    @Nonnull
    @CodingStyleguideUnaware
    public JSCase _case(@Nonnull String string) {
        return this._case(JSExpr.lit(string));
    }

    @Nonnull
    @CodingStyleguideUnaware
    public JSCase _default() {
        if (this.m_aDefaultCase == null) {
            this.m_aDefaultCase = new JSCase(null, true);
        }
        return this.m_aDefaultCase;
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        if (JSOp.hasOperator(this.m_aTest)) {
            jSFormatter.plain("switch ").generatable(this.m_aTest).plain('{').nl();
        } else {
            jSFormatter.plain("switch (").generatable(this.m_aTest).plain("){").nl();
        }
        for (JSCase jSCase : this.m_aCases) {
            jSFormatter.stmt(jSCase);
        }
        if (this.m_aDefaultCase != null) {
            jSFormatter.stmt(this.m_aDefaultCase);
        }
        jSFormatter.plain('}').nl();
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSSwitch jSSwitch = (JSSwitch)object;
        return this.m_aTest.equals(jSSwitch.m_aTest) && this.m_aCases.equals(jSSwitch.m_aCases) && EqualsHelper.equals((Object)this.m_aDefaultCase, (Object)jSSwitch.m_aDefaultCase);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aTest).append(this.m_aCases).append((Object)this.m_aDefaultCase).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("test", (Object)this.m_aTest).append("cases", this.m_aCases).append("defaultCase", (Object)this.m_aDefaultCase).getToString();
    }
}

