/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.JSMarshaller;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;

public class JSStringLiteral
extends AbstractJSExpression {
    private final String m_sStr;

    public JSStringLiteral(@Nonnull String string) {
        this.m_sStr = (String)ValueEnforcer.notNull((Object)string, (String)"String");
    }

    @Nonnull
    public String getContainedString() {
        return this.m_sStr;
    }

    @Nonnull
    @Nonempty
    public static String getAsString(@Nonnull String string) {
        return "'" + JSMarshaller.javaScriptEscape((String)string) + "'";
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain(JSStringLiteral.getAsString(this.m_sStr));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSStringLiteral jSStringLiteral = (JSStringLiteral)object;
        return this.m_sStr.equals(jSStringLiteral.m_sStr);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_sStr).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("string", (Object)this.m_sStr).getToString();
    }
}

