/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public final class JSStatementList
extends AbstractJSStatement {
    private final ICommonsList<IJSStatement> m_aStatements = new CommonsArrayList();

    public JSStatementList() {
    }

    public JSStatementList(IJSStatement ... iJSStatementArray) {
        if (iJSStatementArray != null) {
            for (IJSStatement iJSStatement : iJSStatementArray) {
                this.add(iJSStatement);
            }
        }
    }

    public JSStatementList(@Nullable Iterable<IJSStatement> iterable) {
        if (iterable != null) {
            for (IJSStatement iJSStatement : iterable) {
                this.add(iJSStatement);
            }
        }
    }

    @Nonnull
    public JSStatementList add(@Nonnull IJSStatement iJSStatement) {
        ValueEnforcer.notNull((Object)iJSStatement, (String)"Statement");
        this.m_aStatements.add((Object)iJSStatement);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJSStatement> getAllStatements() {
        return (ICommonsList)this.m_aStatements.getClone();
    }

    @Nonnegative
    public int size() {
        return this.m_aStatements.size();
    }

    public boolean isEmpty() {
        return this.m_aStatements.isEmpty();
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        for (IJSStatement iJSStatement : this.m_aStatements) {
            jSFormatter.stmt(iJSStatement);
        }
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSStatementList jSStatementList = (JSStatementList)object;
        return this.m_aStatements.equals(jSStatementList.m_aStatements);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aStatements).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("statements", this.m_aStatements).getToString();
    }
}

