/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSReturn
extends AbstractJSStatement {
    private final IJSExpression m_aExpr;

    public JSReturn() {
        this(null);
    }

    public JSReturn(@Nullable IJSExpression iJSExpression) {
        this.m_aExpr = iJSExpression;
    }

    @Nullable
    public IJSExpression expr() {
        return this.m_aExpr;
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain("return");
        if (this.m_aExpr != null) {
            jSFormatter.plain(' ').generatable(this.m_aExpr);
        }
        jSFormatter.plain(';').nl();
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSReturn jSReturn = (JSReturn)object;
        return EqualsHelper.equals((Object)this.m_aExpr, (Object)jSReturn.m_aExpr);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aExpr).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("expr", (Object)this.m_aExpr).getToString();
    }
}

