/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;

public class JSRegExLiteral
extends AbstractJSExpression {
    public static final boolean DEFAULT_GLOBAL = false;
    public static final boolean DEFAULT_CASE_INSENSITIVE = false;
    public static final boolean DEFAULT_MULTI_LINE = false;
    private final String m_sRegEx;
    private boolean m_bGlobal = false;
    private boolean m_bCaseInsensitive = false;
    private boolean m_bMultiLine = false;

    public JSRegExLiteral(@Nonnull String string) {
        this.m_sRegEx = (String)ValueEnforcer.notNull((Object)string, (String)"RegEx");
    }

    public boolean global() {
        return this.m_bGlobal;
    }

    @Nonnull
    public JSRegExLiteral global(boolean bl) {
        this.m_bGlobal = bl;
        return this;
    }

    public boolean caseInsensitive() {
        return this.m_bCaseInsensitive;
    }

    @Nonnull
    public JSRegExLiteral caseInsensitive(boolean bl) {
        this.m_bCaseInsensitive = bl;
        return this;
    }

    public boolean multiLine() {
        return this.m_bMultiLine;
    }

    @Nonnull
    public JSRegExLiteral multiLine(boolean bl) {
        this.m_bMultiLine = bl;
        return this;
    }

    @Nonnull
    public JSRegExLiteral gim(boolean bl, boolean bl2, boolean bl3) {
        return this.global(bl).caseInsensitive(bl2).multiLine(bl3);
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain('/').plain(this.m_sRegEx).plain('/');
        if (this.m_bGlobal) {
            jSFormatter.plain('g');
        }
        if (this.m_bCaseInsensitive) {
            jSFormatter.plain('i');
        }
        if (this.m_bMultiLine) {
            jSFormatter.plain('m');
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSRegExLiteral jSRegExLiteral = (JSRegExLiteral)object;
        return this.m_sRegEx.equals(jSRegExLiteral.m_sRegEx) && this.m_bGlobal == jSRegExLiteral.m_bGlobal && this.m_bCaseInsensitive == jSRegExLiteral.m_bCaseInsensitive && this.m_bMultiLine == jSRegExLiteral.m_bMultiLine;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_sRegEx).append(this.m_bGlobal).append(this.m_bCaseInsensitive).append(this.m_bMultiLine).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("regex", (Object)this.m_sRegEx).append("global", this.m_bGlobal).append("caseInsensitive", this.m_bCaseInsensitive).append("multiLine", this.m_bMultiLine).getToString();
    }
}

