/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.JSMarshaller;
import com.helger.html.jscode.AbstractJSAssignmentTarget;
import com.helger.html.jscode.AbstractJSVariable;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSRef
extends AbstractJSAssignmentTarget {
    private String m_sName;
    private AbstractJSVariable<?> m_aVar;

    public JSRef(@Nonnull @Nonempty String string) {
        if (!JSMarshaller.isJSIdentifier((String)string)) {
            throw new IllegalArgumentException("The name '" + string + "' is not a legal JS identifier!");
        }
        this.m_sName = string;
    }

    public JSRef(@Nonnull AbstractJSVariable<?> abstractJSVariable) {
        this.m_aVar = (AbstractJSVariable)ValueEnforcer.notNull(abstractJSVariable, (String)"Var");
    }

    @Nonnull
    @Nonempty
    public final String name() {
        return this.m_sName != null ? this.m_sName : this.m_aVar.name();
    }

    public boolean isFixedName() {
        return this.m_sName != null;
    }

    @Nullable
    public String fixedName() {
        return this.m_sName;
    }

    public boolean isFixedVar() {
        return this.m_aVar != null;
    }

    @Nullable
    public AbstractJSVariable<?> fixedVar() {
        return this.m_aVar;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain(this.name());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSRef jSRef = (JSRef)object;
        return EqualsHelper.equals((Object)this.m_sName, (Object)jSRef.m_sName) && EqualsHelper.equals(this.m_aVar, jSRef.m_aVar);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_sName).append(this.m_aVar).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Name", (Object)this.m_sName).appendIfNotNull("Variable", this.m_aVar).getToString();
    }
}

