/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;

public class JSOpTernary
extends AbstractJSExpression {
    private final IJSExpression m_aExpr1;
    private final String m_sOp1;
    private final IJSExpression m_aExpr2;
    private final String m_sOp2;
    private final IJSExpression m_aExpr3;

    public JSOpTernary(@Nonnull IJSExpression iJSExpression, @Nonnull @Nonempty String string, @Nonnull IJSExpression iJSExpression2, @Nonnull @Nonempty String string2, @Nonnull IJSExpression iJSExpression3) {
        this.m_aExpr1 = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Expr");
        this.m_sOp1 = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Operator1");
        this.m_aExpr2 = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression2, (String)"Expr2");
        this.m_sOp2 = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"Operator2");
        this.m_aExpr3 = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression3, (String)"Expr3");
    }

    @Nonnull
    public IJSExpression expr1() {
        return this.m_aExpr1;
    }

    @Nonnull
    @Nonempty
    public String operator1() {
        return this.m_sOp1;
    }

    @Nonnull
    public IJSExpression expr2() {
        return this.m_aExpr2;
    }

    @Nonnull
    @Nonempty
    public String operator2() {
        return this.m_sOp2;
    }

    @Nonnull
    public IJSExpression expr3() {
        return this.m_aExpr3;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain('(').generatable(this.m_aExpr1).plain(this.m_sOp1).generatable(this.m_aExpr2).plain(this.m_sOp2).generatable(this.m_aExpr3).plain(')');
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSOpTernary jSOpTernary = (JSOpTernary)object;
        return this.m_aExpr1.equals(jSOpTernary.m_aExpr1) && this.m_sOp1.equals(jSOpTernary.m_sOp1) && this.m_aExpr2.equals(jSOpTernary.m_aExpr2) && this.m_sOp2.equals(jSOpTernary.m_sOp2) && this.m_aExpr3.equals(jSOpTernary.m_aExpr3);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aExpr1).append((Object)this.m_sOp1).append((Object)this.m_aExpr2).append((Object)this.m_sOp2).append((Object)this.m_aExpr3).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("expr1", (Object)this.m_aExpr1).append("op1", (Object)this.m_sOp1).append("expr2", (Object)this.m_aExpr2).append("op2", (Object)this.m_sOp2).append("expr3", (Object)this.m_aExpr3).getToString();
    }
}

