/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSGeneratable;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;

public class JSOpBinary
extends AbstractJSExpression {
    private final IJSExpression m_aLeft;
    private final String m_sOp;
    private final IJSGeneratable m_aRight;
    private boolean m_bUseBraces;

    private static boolean _useBraces(@Nonnull IJSExpression iJSExpression, @Nonnull String string, @Nonnull IJSGeneratable iJSGeneratable) {
        JSOpBinary jSOpBinary;
        if (iJSExpression instanceof JSOpBinary) {
            jSOpBinary = (JSOpBinary)iJSExpression;
            if (string.equals(jSOpBinary.m_sOp)) {
                jSOpBinary.m_bUseBraces = false;
            }
        }
        if (iJSGeneratable instanceof JSOpBinary) {
            jSOpBinary = (JSOpBinary)iJSGeneratable;
            if (string.equals(jSOpBinary.m_sOp)) {
                jSOpBinary.m_bUseBraces = false;
            }
        }
        return true;
    }

    public JSOpBinary(@Nonnull IJSExpression iJSExpression, @Nonnull String string, @Nonnull IJSGeneratable iJSGeneratable) {
        this(iJSExpression, string, iJSGeneratable, JSOpBinary._useBraces(iJSExpression, string, iJSGeneratable));
    }

    public JSOpBinary(@Nonnull IJSExpression iJSExpression, @Nonnull String string, @Nonnull IJSGeneratable iJSGeneratable, boolean bl) {
        this.m_aLeft = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Left");
        this.m_sOp = (String)ValueEnforcer.notNull((Object)string, (String)"Operator");
        this.m_aRight = (IJSGeneratable)ValueEnforcer.notNull((Object)iJSGeneratable, (String)"Right");
        this.m_bUseBraces = bl;
    }

    @Nonnull
    public IJSExpression left() {
        return this.m_aLeft;
    }

    @Nonnull
    @Nonempty
    public String operator() {
        return this.m_sOp;
    }

    @Nonnull
    public IJSGeneratable right() {
        return this.m_aRight;
    }

    public boolean useBraces() {
        return this.m_bUseBraces;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        boolean bl = this.m_bUseBraces;
        if (bl) {
            jSFormatter.plain('(');
        }
        jSFormatter.generatable(this.m_aLeft).plain(this.m_sOp).generatable(this.m_aRight);
        if (bl) {
            jSFormatter.plain(')');
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSOpBinary jSOpBinary = (JSOpBinary)object;
        return this.m_aLeft.equals(jSOpBinary.m_aLeft) && this.m_sOp.equals(jSOpBinary.m_sOp) && this.m_aRight.equals(jSOpBinary.m_aRight);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aLeft).append((Object)this.m_sOp).append((Object)this.m_aRight).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("lhs", (Object)this.m_aLeft).append("op", (Object)this.m_sOp).append("rhs", (Object)this.m_aRight).getToString();
    }
}

