/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.html.jscode.AbstractJSAtomNumeric;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.AbstractJSType;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSExprParanthesis;
import com.helger.html.jscode.JSOpBinary;
import com.helger.html.jscode.JSOpTernary;
import com.helger.html.jscode.JSOpUnary;
import com.helger.html.jscode.JSOpUnaryWithParanthesis;
import com.helger.html.jscode.JSStringLiteral;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class JSOp {
    private static final JSOp INSTANCE = new JSOp();

    private JSOp() {
    }

    public static boolean hasOperator(@Nullable IJSExpression iJSExpression) {
        return iJSExpression instanceof JSOpUnary || iJSExpression instanceof JSOpBinary || iJSExpression instanceof JSOpTernary;
    }

    @Nonnull
    public static AbstractJSExpression minus(@Nonnull IJSExpression iJSExpression) {
        if (iJSExpression instanceof AbstractJSAtomNumeric) {
            return ((AbstractJSAtomNumeric)iJSExpression).numericMinus();
        }
        return new JSOpUnaryWithParanthesis("-", iJSExpression);
    }

    @Nonnull
    public static JSExprParanthesis inParantheses(@Nonnull IJSExpression iJSExpression) {
        return new JSExprParanthesis(iJSExpression);
    }

    @Nonnull
    public static AbstractJSExpression not(@Nonnull IJSExpression iJSExpression) {
        if (iJSExpression == JSExpr.TRUE) {
            return JSExpr.FALSE;
        }
        if (iJSExpression == JSExpr.FALSE) {
            return JSExpr.TRUE;
        }
        return new JSOpUnaryWithParanthesis("!", iJSExpression);
    }

    @Nonnull
    public static JSOpUnaryWithParanthesis complement(@Nonnull IJSExpression iJSExpression) {
        return new JSOpUnaryWithParanthesis("~", iJSExpression);
    }

    @Nonnull
    public static AbstractJSExpression incrPostfix(@Nonnull IJSExpression iJSExpression) {
        if (iJSExpression instanceof AbstractJSAtomNumeric) {
            return ((AbstractJSAtomNumeric)iJSExpression).numericIncr();
        }
        return new JSOpUnary(iJSExpression, "++");
    }

    @Nonnull
    public static AbstractJSExpression incrPrefix(@Nonnull IJSExpression iJSExpression) {
        if (iJSExpression instanceof AbstractJSAtomNumeric) {
            return ((AbstractJSAtomNumeric)iJSExpression).numericIncr();
        }
        return new JSOpUnary("++", iJSExpression);
    }

    @Nonnull
    public static AbstractJSExpression decrPostfix(@Nonnull IJSExpression iJSExpression) {
        if (iJSExpression instanceof AbstractJSAtomNumeric) {
            return ((AbstractJSAtomNumeric)iJSExpression).numericDecr();
        }
        return new JSOpUnary(iJSExpression, "--");
    }

    @Nonnull
    public static AbstractJSExpression decrPrefix(@Nonnull IJSExpression iJSExpression) {
        if (iJSExpression instanceof AbstractJSAtomNumeric) {
            return ((AbstractJSAtomNumeric)iJSExpression).numericDecr();
        }
        return new JSOpUnary("--", iJSExpression);
    }

    @Nonnull
    public static JSOpUnary typeof(@Nonnull IJSExpression iJSExpression) {
        return new JSOpUnary("typeof ", iJSExpression);
    }

    @Nonnull
    public static AbstractJSExpression plus(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        if (iJSExpression instanceof JSStringLiteral && iJSExpression2 instanceof JSStringLiteral) {
            return new JSStringLiteral(((JSStringLiteral)iJSExpression).getContainedString() + ((JSStringLiteral)iJSExpression2).getContainedString());
        }
        if (iJSExpression instanceof AbstractJSAtomNumeric && iJSExpression2 instanceof AbstractJSAtomNumeric) {
            return ((AbstractJSAtomNumeric)iJSExpression).numericPlus((AbstractJSAtomNumeric)iJSExpression2);
        }
        return new JSOpBinary(iJSExpression, "+", iJSExpression2);
    }

    @Nonnull
    public static AbstractJSExpression minus(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        if (iJSExpression instanceof AbstractJSAtomNumeric && iJSExpression2 instanceof AbstractJSAtomNumeric) {
            return ((AbstractJSAtomNumeric)iJSExpression).numericMinus((AbstractJSAtomNumeric)iJSExpression2);
        }
        return new JSOpBinary(iJSExpression, "-", iJSExpression2);
    }

    @Nonnull
    public static AbstractJSExpression mul(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        if (iJSExpression instanceof AbstractJSAtomNumeric && iJSExpression2 instanceof AbstractJSAtomNumeric) {
            return ((AbstractJSAtomNumeric)iJSExpression).numericMul((AbstractJSAtomNumeric)iJSExpression2);
        }
        return new JSOpBinary(iJSExpression, "*", iJSExpression2);
    }

    @Nonnull
    public static AbstractJSExpression div(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        if (iJSExpression instanceof AbstractJSAtomNumeric && iJSExpression2 instanceof AbstractJSAtomNumeric) {
            return ((AbstractJSAtomNumeric)iJSExpression).numericDiv((AbstractJSAtomNumeric)iJSExpression2);
        }
        return new JSOpBinary(iJSExpression, "/", iJSExpression2);
    }

    @Nonnull
    public static AbstractJSExpression mod(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        if (iJSExpression instanceof AbstractJSAtomNumeric && iJSExpression2 instanceof AbstractJSAtomNumeric) {
            return ((AbstractJSAtomNumeric)iJSExpression).numericMod((AbstractJSAtomNumeric)iJSExpression2);
        }
        return new JSOpBinary(iJSExpression, "%", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary shl(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, "<<", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary shr(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, ">>", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary shrz(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, ">>>", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary band(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, "&", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary bor(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, "|", iJSExpression2);
    }

    @Nonnull
    public static IJSExpression cand(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        if (iJSExpression == JSExpr.TRUE) {
            return iJSExpression2;
        }
        if (iJSExpression2 == JSExpr.TRUE) {
            return iJSExpression;
        }
        if (iJSExpression == JSExpr.FALSE || iJSExpression2 == JSExpr.FALSE) {
            return JSExpr.FALSE;
        }
        return new JSOpBinary(iJSExpression, "&&", iJSExpression2);
    }

    @Nonnull
    public static IJSExpression cor(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        if (iJSExpression == JSExpr.TRUE || iJSExpression2 == JSExpr.TRUE) {
            return JSExpr.TRUE;
        }
        if (iJSExpression == JSExpr.FALSE) {
            return iJSExpression2;
        }
        if (iJSExpression2 == JSExpr.FALSE) {
            return iJSExpression;
        }
        return new JSOpBinary(iJSExpression, "||", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary xor(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, "^", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary lt(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, "<", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary lte(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, "<=", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary gt(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, ">", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary gte(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, ">=", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary eq(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, "==", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary eeq(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, "===", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary ne(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, "!=", iJSExpression2);
    }

    @Nonnull
    public static JSOpBinary ene(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSOpBinary(iJSExpression, "!==", iJSExpression2);
    }

    @Nonnull
    @CodingStyleguideUnaware
    public static JSOpBinary _instanceof(@Nonnull IJSExpression iJSExpression, @Nonnull AbstractJSType abstractJSType) {
        return new JSOpBinary(iJSExpression, " instanceof ", abstractJSType);
    }

    @Nonnull
    public static JSOpTernary cond(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2, @Nonnull IJSExpression iJSExpression3) {
        return new JSOpTernary(iJSExpression, "?", iJSExpression2, ":", iJSExpression3);
    }
}

