/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.WillCloseWhenClosed;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.js.IHasJSCode;
import com.helger.html.js.IHasJSCodeWithSettings;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.js.JSWriterSettings;
import com.helger.html.jscode.AbstractJSType;
import com.helger.html.jscode.AbstractJSVariable;
import com.helger.html.jscode.IJSDeclaration;
import com.helger.html.jscode.IJSGeneratable;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSPackage;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class JSFormatter
implements Closeable {
    private final PrintWriter m_aPW;
    private final IJSWriterSettings m_aSettings;
    private int m_nIndentLevel;
    private String m_sIndentCache = "";
    private boolean m_bAtBeginningOfLine = true;

    public JSFormatter(@Nonnull @WillCloseWhenClosed Writer writer) {
        this(writer, (IJSWriterSettings)null);
    }

    public JSFormatter(@Nonnull @WillCloseWhenClosed PrintWriter printWriter) {
        this(printWriter, (IJSWriterSettings)null);
    }

    public JSFormatter(@Nonnull @WillCloseWhenClosed Writer writer, @Nullable IJSWriterSettings iJSWriterSettings) {
        this(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), iJSWriterSettings);
    }

    public JSFormatter(@Nonnull @WillCloseWhenClosed PrintWriter printWriter, @Nullable IJSWriterSettings iJSWriterSettings) {
        this.m_aPW = (PrintWriter)ValueEnforcer.notNull((Object)printWriter, (String)"PrintWriter");
        this.m_aSettings = JSWriterSettings.createCloneOnDemand((IJSWriterSettings)iJSWriterSettings);
    }

    @Nonnull
    public IJSWriterSettings getSettings() {
        return this.m_aSettings;
    }

    @Override
    public void close() throws IOException {
        this.m_aPW.close();
    }

    @Nonnull
    public JSFormatter outdent() {
        if (this.m_aSettings.isIndentAndAlign()) {
            this.outdentAlways();
        }
        return this;
    }

    @Nonnull
    public JSFormatter outdentAlways() {
        if (this.m_nIndentLevel == 0) {
            throw new IllegalStateException("Nothing left to outdent!");
        }
        --this.m_nIndentLevel;
        this.m_sIndentCache = this.m_sIndentCache.substring(0, this.m_nIndentLevel * this.m_aSettings.getIndent().length());
        return this;
    }

    @Nonnull
    public JSFormatter indent() {
        if (this.m_aSettings.isIndentAndAlign()) {
            this.indentAlways();
        }
        return this;
    }

    @Nonnull
    public JSFormatter indentAlways() {
        ++this.m_nIndentLevel;
        this.m_sIndentCache = this.m_sIndentCache + this.m_aSettings.getIndent();
        return this;
    }

    private void _spaceIfNeeded() {
        if (this.m_bAtBeginningOfLine) {
            if (this.m_nIndentLevel > 0) {
                this.m_aPW.print(this.m_sIndentCache);
            }
            this.m_bAtBeginningOfLine = false;
        }
    }

    @Nonnull
    public JSFormatter plain(char c) {
        this._spaceIfNeeded();
        this.m_aPW.print(c);
        return this;
    }

    @Nonnull
    public JSFormatter plain(@Nonnull String string) {
        this._spaceIfNeeded();
        this.m_aPW.print(string);
        return this;
    }

    @Nonnull
    public JSFormatter type(@Nonnull AbstractJSType abstractJSType) {
        this.plain(abstractJSType.name());
        return this;
    }

    @Nonnull
    public JSFormatter nl() {
        if (this.m_aSettings.isIndentAndAlign()) {
            this.nlFix();
        }
        return this;
    }

    @Nonnull
    public JSFormatter nlFix() {
        this.m_aPW.print(this.m_aSettings.getNewLineString());
        this.m_bAtBeginningOfLine = true;
        return this;
    }

    @Nonnull
    public JSFormatter generatable(@Nonnull IJSGeneratable iJSGeneratable) {
        iJSGeneratable.generate(this);
        return this;
    }

    @Nonnull
    public JSFormatter generatable(@Nonnull Iterable<? extends IJSGeneratable> iterable) {
        boolean bl = true;
        for (IJSGeneratable iJSGeneratable : iterable) {
            if (bl) {
                bl = false;
            } else {
                this.plain(',');
            }
            this.generatable(iJSGeneratable);
        }
        return this;
    }

    @Nonnull
    public JSFormatter decl(@Nonnull IJSDeclaration iJSDeclaration) {
        iJSDeclaration.declare(this);
        return this;
    }

    @Nonnull
    public JSFormatter stmt(@Nonnull IJSStatement iJSStatement) {
        iJSStatement.state(this);
        return this;
    }

    @Nonnull
    public JSFormatter variable(@Nonnull AbstractJSVariable<?> abstractJSVariable) {
        abstractJSVariable.bind(this);
        return this;
    }

    public void pkg(@Nonnull JSPackage jSPackage) {
        for (IHasJSCode iHasJSCode : jSPackage.directMembers()) {
            if (iHasJSCode instanceof IJSDeclaration) {
                this.decl((IJSDeclaration)iHasJSCode);
                continue;
            }
            if (iHasJSCode instanceof IJSStatement) {
                this.stmt((IJSStatement)iHasJSCode);
                continue;
            }
            if (iHasJSCode instanceof JSPackage) {
                this.pkg((JSPackage)iHasJSCode);
                continue;
            }
            if (iHasJSCode instanceof IHasJSCodeWithSettings) {
                this.plain(((IHasJSCodeWithSettings)iHasJSCode).getJSCode(this.m_aSettings));
                continue;
            }
            this.plain(iHasJSCode.getJSCode());
        }
    }
}

