/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.AbstractJSVariable;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSGeneratable;
import com.helger.html.jscode.JSBlock;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSLet;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSForLoop
extends AbstractJSStatement {
    private final ICommonsList<IJSExpression> m_aInits = new CommonsArrayList();
    private IJSExpression m_aTest;
    private final ICommonsList<IJSExpression> m_aUpdates = new CommonsArrayList();
    private JSBlock m_aBody;

    @Nonnull
    public JSForLoop simpleLoop(@Nonnull @Nonempty String string, int n, int n2) {
        JSLet jSLet = this.init(string, n);
        if (n2 >= n) {
            this.test(jSLet.lt(n2));
            this.update(jSLet.incrPostfix());
        } else {
            this.test(jSLet.gt(n2));
            this.update(jSLet.decrPostfix());
        }
        return this;
    }

    @Nonnull
    public JSLet init(@Nonnull @Nonempty String string, int n) {
        return this.init(string, (IJSExpression)JSExpr.lit(n));
    }

    @Nonnull
    public JSLet init(@Nonnull @Nonempty String string, long l) {
        return this.init(string, (IJSExpression)JSExpr.lit(l));
    }

    @Nonnull
    public JSLet init(@Nonnull @Nonempty String string, @Nonnull IJSExpression iJSExpression) {
        ValueEnforcer.notNull((Object)iJSExpression, (String)"InitExpression");
        JSLet jSLet = new JSLet(string, iJSExpression);
        this.m_aInits.add((Object)jSLet);
        return jSLet;
    }

    public void init(@Nonnull JSLet jSLet, @Nonnull IJSExpression iJSExpression) {
        this.m_aInits.add((Object)jSLet.assign(iJSExpression));
    }

    public void test(@Nonnull IJSExpression iJSExpression) {
        this.m_aTest = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Test");
    }

    public void update(@Nonnull IJSExpression iJSExpression) {
        ValueEnforcer.notNull((Object)iJSExpression, (String)"Expr");
        this.m_aUpdates.add((Object)iJSExpression);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJSExpression> updates() {
        return (ICommonsList)this.m_aUpdates.getClone();
    }

    @Nonnull
    public JSBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JSBlock();
        }
        return this.m_aBody;
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain("for(");
        boolean bl = true;
        for (IJSExpression iJSExpression : this.m_aInits) {
            if (bl) {
                bl = false;
            } else {
                jSFormatter.plain(',');
            }
            if (iJSExpression instanceof AbstractJSVariable) {
                AbstractJSVariable abstractJSVariable = (AbstractJSVariable)iJSExpression;
                jSFormatter.plain(abstractJSVariable.getJSVarMode().getCode()).variable(abstractJSVariable);
                continue;
            }
            jSFormatter.generatable(iJSExpression);
        }
        jSFormatter.plain(';').generatable(this.m_aTest).plain(';').generatable((Iterable<? extends IJSGeneratable>)this.m_aUpdates).plain(')');
        if (this.m_aBody != null) {
            jSFormatter.generatable(this.m_aBody).nl();
        } else {
            jSFormatter.plain(';').nl();
        }
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSForLoop jSForLoop = (JSForLoop)object;
        return this.m_aInits.equals(jSForLoop.m_aInits) && EqualsHelper.equals((Object)this.m_aTest, (Object)jSForLoop.m_aTest) && this.m_aUpdates.equals(jSForLoop.m_aUpdates) && EqualsHelper.equals((Object)this.m_aBody, (Object)jSForLoop.m_aBody);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aInits).append((Object)this.m_aTest).append(this.m_aUpdates).append((Object)this.m_aBody).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("inits", this.m_aInits).append("test", (Object)this.m_aTest).append("updates", this.m_aUpdates).append("body", (Object)this.m_aBody).getToString();
    }
}

