/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.AbstractJSVariable;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSBlock;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSLet;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSForIn
extends AbstractJSStatement {
    private final JSLet m_aLoopVar;
    private final IJSExpression m_aCollection;
    private JSBlock m_aBody;

    public JSForIn(@Nonnull @Nonempty String string, @Nonnull IJSExpression iJSExpression) {
        this(new JSLet(string), iJSExpression);
    }

    public JSForIn(@Nonnull JSLet jSLet, @Nonnull IJSExpression iJSExpression) {
        this.m_aLoopVar = (JSLet)ValueEnforcer.notNull((Object)jSLet, (String)"LoopVar");
        this.m_aCollection = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Collection");
    }

    @Nonnull
    public JSLet variable() {
        return this.m_aLoopVar;
    }

    @Nonnull
    public IJSExpression collection() {
        return this.m_aCollection;
    }

    @Nonnull
    public JSBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JSBlock();
        }
        return this.m_aBody;
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain("for(").plain(AbstractJSVariable.EJSVarMode.LET.getCode()).variable(this.m_aLoopVar).plain(" in ").generatable(this.m_aCollection).plain(')');
        if (this.m_aBody != null) {
            jSFormatter.generatable(this.m_aBody).nl();
        } else {
            jSFormatter.plain(';').nl();
        }
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSForIn jSForIn = (JSForIn)object;
        return this.m_aLoopVar.equals(jSForIn.m_aLoopVar) && this.m_aCollection.equals(jSForIn.m_aCollection) && EqualsHelper.equals((Object)this.m_aBody, (Object)jSForIn.m_aBody);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aLoopVar).append((Object)this.m_aCollection).append((Object)this.m_aBody).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("loopVar", (Object)this.m_aLoopVar).append("collection", (Object)this.m_aCollection).append("body", (Object)this.m_aBody).getToString();
    }
}

