/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.IJSDocCommentable;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSCommentMultiLine;
import com.helger.html.jscode.JSDefinedClass;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSNameAlreadyExistsException;
import com.helger.html.jscode.JSVar;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSFieldVar
extends JSVar
implements IJSDocCommentable {
    private final JSDefinedClass m_aOwnerClass;
    private JSCommentMultiLine m_aJSDoc;

    public JSFieldVar(@Nonnull JSDefinedClass jSDefinedClass, @Nonnull @Nonempty String string, @Nullable IJSExpression iJSExpression) {
        super(string, iJSExpression);
        this.m_aOwnerClass = (JSDefinedClass)ValueEnforcer.notNull((Object)jSDefinedClass, (String)"OwnerClass");
    }

    @Nonnull
    public JSDefinedClass parentClass() {
        return this.m_aOwnerClass;
    }

    @Override
    @Nonnull
    public JSFieldVar name(@Nonnull @Nonempty String string) {
        String string2 = this.name();
        if (!string2.equals(string)) {
            JSFieldVar jSFieldVar = this.m_aOwnerClass.getFieldOfName(string);
            if (jSFieldVar != null) {
                throw new JSNameAlreadyExistsException(jSFieldVar);
            }
            this.m_aOwnerClass.removeField(this);
            super.name(string);
            this.m_aOwnerClass.addField(this);
        }
        return this;
    }

    @Override
    @Nonnull
    public JSCommentMultiLine jsDoc() {
        if (this.m_aJSDoc == null) {
            this.m_aJSDoc = new JSCommentMultiLine();
        }
        return this.m_aJSDoc;
    }

    @Override
    public void declare(@Nonnull JSFormatter jSFormatter) {
        if (this.m_aJSDoc != null) {
            jSFormatter.generatable(this.m_aJSDoc);
        }
        super.declare(jSFormatter);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSFieldVar jSFieldVar = (JSFieldVar)object;
        return this.m_aOwnerClass.name().equals(jSFieldVar.m_aOwnerClass.name()) && EqualsHelper.equals((Object)this.m_aJSDoc, (Object)jSFieldVar.m_aJSDoc);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aOwnerClass.name()).append((Object)this.m_aJSDoc).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("ownerClass", (Object)this.m_aOwnerClass).appendIfNotNull("jsDoc", (Object)this.m_aJSDoc).getToString();
    }
}

