/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.AbstractJSClass;
import com.helger.html.jscode.AbstractJSVariable;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSGeneratable;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.jscode.JSRef;
import jakarta.annotation.Nonnull;

public class JSFieldRef
extends JSRef {
    private final IJSGeneratable m_aObject;

    public JSFieldRef(@Nonnull IJSGeneratable iJSGeneratable, @Nonnull @Nonempty String string) {
        super(string);
        this.m_aObject = (IJSGeneratable)ValueEnforcer.notNull((Object)iJSGeneratable, (String)"Object");
    }

    public JSFieldRef(@Nonnull IJSGeneratable iJSGeneratable, @Nonnull AbstractJSVariable<?> abstractJSVariable) {
        super(abstractJSVariable);
        this.m_aObject = (IJSGeneratable)ValueEnforcer.notNull((Object)iJSGeneratable, (String)"Object");
    }

    @Nonnull
    public IJSGeneratable object() {
        return this.m_aObject;
    }

    public boolean isInvocable() {
        return this.m_aObject instanceof AbstractJSClass || this.m_aObject instanceof IJSExpression;
    }

    @Nonnull
    public JSInvocation invoke() {
        if (this.m_aObject instanceof AbstractJSClass) {
            return new JSInvocation((AbstractJSClass)this.m_aObject, this.name());
        }
        if (this.m_aObject instanceof IJSExpression) {
            return new JSInvocation((IJSExpression)this.m_aObject, this.name());
        }
        throw new IllegalStateException("The present object " + String.valueOf(this.m_aObject) + " cannot be invoked (at the moment)");
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.generatable(this.m_aObject).plain('.').plain(this.name());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSFieldRef jSFieldRef = (JSFieldRef)object;
        return this.m_aObject.equals(jSFieldRef.m_aObject);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aObject).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("object", (Object)this.m_aObject).getToString();
    }
}

