/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;

public class JSExprParanthesis
extends AbstractJSExpression {
    private final IJSExpression m_aExpr;

    public JSExprParanthesis(@Nonnull IJSExpression iJSExpression) {
        this.m_aExpr = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Expr");
    }

    @Nonnull
    public IJSExpression expr() {
        return this.m_aExpr;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain('(').generatable(this.m_aExpr).plain(')');
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSExprParanthesis jSExprParanthesis = (JSExprParanthesis)object;
        return this.m_aExpr.equals(jSExprParanthesis.m_aExpr);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aExpr).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("expr", (Object)this.m_aExpr).getToString();
    }
}

