/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.IJSAssignmentTarget;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSDecrPostfix
extends AbstractJSStatement {
    private final IJSAssignmentTarget m_aExpr;

    public JSDecrPostfix(@Nonnull IJSAssignmentTarget iJSAssignmentTarget) {
        this.m_aExpr = (IJSAssignmentTarget)ValueEnforcer.notNull((Object)iJSAssignmentTarget, (String)"Expr");
    }

    @Nonnull
    public IJSAssignmentTarget expr() {
        return this.m_aExpr;
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.generatable(this.m_aExpr).plain("--;").nl();
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSDecrPostfix jSDecrPostfix = (JSDecrPostfix)object;
        return this.m_aExpr.equals(jSDecrPostfix.m_aExpr);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aExpr).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("expr", (Object)this.m_aExpr).getToString();
    }
}

